/*
 * Decompiled with CFR 0.152.
 */
package ellestuff.ellediscs.recipes;

import ellestuff.ellediscs.items.CustomDyeableItem;
import ellestuff.ellediscs.recipes.DiscRecipeSerializer;
import java.util.Optional;
import net.minecraft.class_1768;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class CustomDiscRecipe
extends class_1852 {
    private final class_1856 record;
    private final class_1856 label;
    private final Optional<class_1856> modifier;
    private final class_1799 output;
    private final boolean accents;

    public CustomDiscRecipe(class_1856 record, class_1856 label, Optional<class_1856> modifier, class_1799 output, boolean allowsAccents, class_2960 identifier, class_7710 craftingRecipeCategory) {
        super(identifier, craftingRecipeCategory);
        this.record = record;
        this.label = label;
        this.modifier = modifier;
        this.output = output;
        this.accents = allowsAccents;
    }

    public boolean matches(class_8566 recipeInputInventory, class_1937 world) {
        boolean hasRecord = false;
        boolean hasLabel = false;
        boolean hasModifier = false;
        for (int i = 0; i < recipeInputInventory.method_5439(); ++i) {
            class_1799 itemStack = recipeInputInventory.method_5438(i);
            if (this.record.method_8093(itemStack)) {
                if (hasRecord) {
                    return false;
                }
                hasRecord = true;
                continue;
            }
            if (this.label.method_8093(itemStack)) {
                if (hasLabel) {
                    return false;
                }
                hasLabel = true;
                continue;
            }
            if (this.modifier.isPresent() && this.modifier.get().method_8093(itemStack)) {
                if (hasModifier && !itemStack.method_7960()) {
                    return false;
                }
                hasModifier = true;
                continue;
            }
            if (itemStack.method_7960()) continue;
            return false;
        }
        return hasRecord && hasLabel && (hasModifier || this.modifier.isEmpty());
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    public class_1856 getRecord() {
        return this.record;
    }

    public class_1856 getLabel() {
        return this.label;
    }

    public Optional<class_1856> getModifier() {
        return this.modifier;
    }

    public class_1799 getOutput() {
        return this.output;
    }

    public Boolean getAccentBool() {
        return this.accents;
    }

    public class_1799 craft(class_8566 recipeInputInventory, class_5455 dynamicRegistryManager) {
        class_1799 result = this.output.method_7972();
        class_2487 nbtCompound = result.method_7911("colours");
        for (int i = 0; i < recipeInputInventory.method_5439(); ++i) {
            class_1799 itemStack = recipeInputInventory.method_5438(i);
            if (itemStack.method_7960() || !(itemStack.method_7909() instanceof class_1768) || !((class_1768)itemStack.method_7909()).method_7801(itemStack)) continue;
            if (this.record.method_8093(itemStack)) {
                nbtCompound.method_10569("RecordColour", ((CustomDyeableItem)itemStack.method_7909()).method_7800(itemStack));
                continue;
            }
            if (!this.label.method_8093(itemStack)) continue;
            nbtCompound.method_10569("LabelColour", ((CustomDyeableItem)itemStack.method_7909()).method_7800(itemStack));
        }
        return result;
    }

    public DiscRecipeSerializer getSerializer() {
        return DiscRecipeSerializer.INSTANCE;
    }
}

