/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import fzzyhmstrs.emi_loot.client.ClientResourceData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5684;
import net.minecraft.class_7923;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EntityEmiStack
extends EmiStack {
    @Nullable
    private final class_1297 entity;
    private final EntityRenderContext ctx;

    protected EntityEmiStack(@Nullable class_1297 entity) {
        this(entity, 8.0);
    }

    protected EntityEmiStack(@Nullable class_1297 entity, double scale) {
        this.entity = entity;
        if (entity != null) {
            boolean hasTransform = ClientResourceData.MOB_ROTATIONS.containsKey(entity.method_5864());
            Vector3f transform = ClientResourceData.MOB_ROTATIONS.getOrDefault(entity.method_5864(), new Vector3f(0.0f, 0.0f, 0.0f)).mul((float)Math.PI / 180);
            this.ctx = new EntityRenderContext(scale, hasTransform, transform);
        } else {
            this.ctx = new EntityRenderContext(scale, false, new Vector3f(0.0f, 0.0f, 0.0f));
        }
    }

    public static EntityEmiStack of(@Nullable class_1297 entity) {
        return new EntityEmiStack(entity);
    }

    public static EntityEmiStack ofScaled(@Nullable class_1297 entity, double scale) {
        return new EntityEmiStack(entity, scale);
    }

    public EmiStack copy() {
        EntityEmiStack stack = new EntityEmiStack(this.entity);
        stack.setRemainder(this.getRemainder().copy());
        stack.comparison = this.comparison;
        return stack;
    }

    public boolean isEmpty() {
        return this.entity == null;
    }

    public void render(class_332 matrices, int x, int y, float delta, int flags) {
        if (this.entity != null) {
            class_1297 class_12972 = this.entity;
            if (class_12972 instanceof class_1309) {
                class_1309 living = (class_1309)class_12972;
                EntityEmiStack.renderEntity(matrices.method_51448(), x + 8, (int)((double)(y + 8) + this.ctx.size), this.ctx, living);
            } else {
                EntityEmiStack.renderEntity(matrices.method_51448(), (int)((double)x + 2.0 * this.ctx.size / 2.0), (int)((double)y + 2.0 * this.ctx.size), this.ctx, this.entity);
            }
        }
    }

    public class_2487 getNbt() {
        throw new UnsupportedOperationException("EntityEmiStack is not intended for NBT handling");
    }

    public Object getKey() {
        return this.entity;
    }

    public class_2960 getId() {
        if (this.entity == null) {
            throw new RuntimeException("Entity is null");
        }
        return class_7923.field_41177.method_10221((Object)this.entity.method_5864());
    }

    public List<class_2561> getTooltipText() {
        return List.of(this.getName());
    }

    public List<class_5684> getTooltip() {
        ArrayList<class_5684> list = new ArrayList<class_5684>();
        if (this.entity != null) {
            list.addAll(this.getTooltipText().stream().map(class_2561::method_30937).map(class_5684::method_32662).toList());
            EmiTooltipComponents.appendModName(list, (String)class_7923.field_41177.method_10221((Object)this.entity.method_5864()).method_12836());
            if (!this.getRemainder().isEmpty()) {
                list.add(EmiTooltipComponents.getRemainderTooltipComponent((EmiIngredient)this));
            }
        }
        return list;
    }

    public class_2561 getName() {
        return this.entity != null ? this.entity.method_5477() : class_2561.method_43470((String)"yet another missingno");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renderEntity(class_4587 matrices, int x, int y, EntityRenderContext ctx, class_1309 entity) {
        class_310 client = class_310.method_1551();
        double width = client.method_22683().method_4486();
        double height = client.method_22683().method_4502();
        float mouseX = (float)(client.field_1729.method_1603() * width / (double)client.method_22683().method_4480());
        float mouseY = (float)(client.field_1729.method_1604() * height / (double)client.method_22683().method_4507());
        double posX = (double)mouseX - width / 2.0 + 63.0;
        if (Double.isNaN(posX)) {
            return;
        }
        double posY = (double)mouseY - height / 2.0;
        if (Double.isNaN(posY)) {
            return;
        }
        float f = (float)Math.atan(-posX / 40.0);
        float g = (float)Math.atan(-posY / 40.0);
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_34425(matrices.method_23760().method_23761());
        matrixStack.method_22904((double)x, (double)y, 1050.0);
        matrixStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack2 = new class_4587();
        matrixStack2.method_22904(0.0, 0.0, 1000.0);
        matrixStack2.method_22905((float)ctx.size, (float)ctx.size, (float)ctx.size);
        Quaternionf quaternion = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternion2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180) * class_3532.method_15362((float)ctx.transform.z) - f * 20.0f * ((float)Math.PI / 180) * class_3532.method_15374((float)ctx.transform.z));
        if (ctx.hasTransform) {
            Quaternionf quaternion3 = new Quaternionf().rotateXYZ(ctx.transform.x, ctx.transform.y, ctx.transform.z);
            quaternion.mul((Quaternionfc)quaternion3);
        }
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack2.method_22907(quaternion);
        float h = entity.field_6283;
        float i = entity.method_36454();
        float j = entity.method_36455();
        float k = entity.field_6259;
        float l = entity.field_6241;
        entity.field_6283 = 180.0f + (f * 20.0f * class_3532.method_15362((float)ctx.transform.z) + g * 20.0f * class_3532.method_15374((float)ctx.transform.z));
        float yaw = 180.0f + (f * 40.0f * class_3532.method_15362((float)ctx.transform.z) + g * 40.0f * class_3532.method_15374((float)ctx.transform.z));
        entity.method_36456(yaw);
        float pitch = -g * 20.0f * class_3532.method_15362((float)ctx.transform.z) + -f * 20.0f * class_3532.method_15374((float)ctx.transform.z);
        entity.method_36457(pitch);
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        try {
            RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack2, (class_4597)immediate, 0xF000F0));
        }
        finally {
            immediate.method_22993();
        }
        entityRenderDispatcher.method_3948(true);
        entity.field_6283 = h;
        entity.method_36456(i);
        entity.method_36457(j);
        entity.field_6259 = k;
        entity.field_6241 = l;
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renderEntity(class_4587 matrices, int x, int y, EntityRenderContext ctx, class_1297 entity) {
        class_310 client = class_310.method_1551();
        class_312 mouse = client.field_1729;
        float w = 1920.0f;
        float h = 1080.0f;
        class_437 screen = client.field_1755;
        if (screen != null) {
            w = screen.field_22789;
            h = screen.field_22790;
        }
        float mouseX = (float)((double)(w + 51.0f) - mouse.method_1603());
        float mouseY = (float)((double)(h + 75.0f - 50.0f) - mouse.method_1604());
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_34425(matrices.method_23760().method_23761());
        matrixStack.method_22904((double)x, (double)y, 1050.0);
        matrixStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack2 = new class_4587();
        matrixStack2.method_22904(0.0, 0.0, 1000.0);
        matrixStack2.method_22905((float)ctx.size, (float)ctx.size, (float)ctx.size);
        Quaternionf quaternion = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternion2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180) * class_3532.method_15362((float)ctx.transform.z) - f * 20.0f * ((float)Math.PI / 180) * class_3532.method_15374((float)ctx.transform.z));
        if (ctx.hasTransform) {
            Quaternionf quaternion3 = new Quaternionf().rotateXYZ(ctx.transform.x, ctx.transform.y, ctx.transform.z);
            quaternion.mul((Quaternionfc)quaternion3);
        }
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack2.method_22907(quaternion);
        float i = entity.method_36454();
        float j = entity.method_36455();
        entity.method_36456(180.0f + (f * 40.0f * class_3532.method_15362((float)ctx.transform.z) + g * 40.0f * class_3532.method_15374((float)ctx.transform.z)));
        entity.method_36457(-g * 20.0f * class_3532.method_15362((float)ctx.transform.z) + -f * 20.0f * class_3532.method_15374((float)ctx.transform.z));
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        try {
            RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack2, (class_4597)immediate, 0xF000F0));
        }
        finally {
            immediate.method_22993();
        }
        entityRenderDispatcher.method_3948(true);
        entity.method_36456(i);
        entity.method_36457(j);
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    private record EntityRenderContext(double size, boolean hasTransform, Vector3f transform) {
        static EntityRenderContext EMPTY = new EntityRenderContext(8.0, false, new Vector3f(0.0f, 0.0f, 0.0f));
    }
}

