/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootClientAgnos;
import fzzyhmstrs.emi_loot.client.ClientBlockLootTable;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.client.InitializedSupplier;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.BlockStateEmiStack;
import fzzyhmstrs.emi_loot.util.ConditionalStack;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.IconGroupEmiWidget;
import fzzyhmstrs.emi_loot.util.SymbolText;
import fzzyhmstrs.emi_loot.util.WidgetRowBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlockLootRecipe
implements EmiRecipe {
    private final class_2960 id;
    private final InitializedSupplier<EmiStack> inputStack;
    private final InitializedSupplier<List<EmiStack>> outputStacks;
    private final List<WidgetRowBuilder> rowBuilderList;
    private final boolean isSimple;
    private List<EmiIngredient> inputStacks;

    public BlockLootRecipe(BlockLootRecipeData data) {
        this.id = data.id;
        this.inputStack = data.inputStack;
        this.outputStacks = data.outputStacks;
        this.rowBuilderList = data.rowBuilderList;
        this.isSimple = data.guaranteed;
    }

    public void init() {
        this.inputStack.init();
        this.outputStacks.init();
        this.inputStacks = this.inputStack.get().getItemStack().method_7960() ? Collections.emptyList() : List.of((EmiIngredient)this.inputStack.get());
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.BLOCK_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputStacks;
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputStacks.get();
    }

    public int getDisplayWidth() {
        return EMILoot.config.isTooltipStyle() ? 144 : 160;
    }

    public int getDisplayHeight() {
        if (EMILoot.config.isTooltipStyle()) {
            int stacks = this.outputStacks.get().size();
            if (stacks <= 5) {
                return 18;
            }
            if (EMILoot.config.isCompact(EMILoot.Type.BLOCK)) {
                int ingredients = 0;
                for (WidgetRowBuilder builder : this.rowBuilderList) {
                    ingredients += builder.ingredientCount();
                }
                if (ingredients <= 4) {
                    return 29;
                }
                return 18 + 18 * ((ingredients - 5) / 8 + 1);
            }
            return 18 + 18 * ((stacks - 6) / 8 + 1);
        }
        return 23 + 29 * (this.rowBuilderList.size() - 1);
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputStack.get(), 0, 0);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 20, 0);
        int x = 46;
        int y = 0;
        if (EMILoot.config.isTooltipStyle()) {
            List stacks = this.outputStacks.get().size() <= 4 || !EMILoot.config.isCompact(EMILoot.Type.BLOCK) ? (List)this.rowBuilderList.stream().map(WidgetRowBuilder::stacks).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll) : (List)this.rowBuilderList.stream().map(WidgetRowBuilder::ingredients).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
            int i = 3;
            int j = 0;
            for (ConditionalStack stack : stacks) {
                SlotWidget widget = widgets.addSlot(stack.getIngredient(), i * 18, 18 * j);
                String rounded = FloatTrimmer.trimFloatString(Math.max(stack.weight() / 100.0f, 0.01f), (Integer)EMILoot.config.chanceDecimalPlaces.get());
                widget.appendTooltip((class_2561)FcText.INSTANCE.translatable("emi_loot.rolls", new Object[]{rounded}).method_27692(class_124.field_1080));
                if (EMILoot.config.isNotPlain()) {
                    for (class_3545<Integer, class_2561> pair : stack.conditions()) {
                        widget.appendTooltip((class_2561)SymbolText.of((Integer)pair.method_15442(), (class_2561)pair.method_15441()));
                    }
                }
                if (++i <= 7) continue;
                i = 0;
                ++j;
            }
        } else {
            for (WidgetRowBuilder builder : this.rowBuilderList) {
                for (ClientBuiltPool pool : builder.getPoolList()) {
                    IconGroupEmiWidget widget = EMILootClientAgnos.createIconGroupEmiWidget(x, y, pool);
                    widgets.add((Widget)widget);
                    x += widget.getWidth() + 6;
                }
                y += 29;
                x = 46;
            }
        }
    }

    public boolean supportsRecipeTree() {
        return this.isSimple;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }

    public record BlockLootRecipeData(class_2960 id, List<WidgetRowBuilder> rowBuilderList, boolean guaranteed, InitializedSupplier<EmiStack> inputStack, InitializedSupplier<List<EmiStack>> outputStacks) {
        public static BlockLootRecipeData of(ClientBlockLootTable loot) {
            ArrayList<class_1799> itemStackList = new ArrayList<class_1799>();
            boolean allStacksGuaranteed = true;
            ArrayList<WidgetRowBuilder> rowBuilderList = new ArrayList<WidgetRowBuilder>();
            class_2960 blockId = loot.blockId;
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(blockId);
            loot.build((class_1937)class_310.method_1551().field_1687, block);
            for (ClientBuiltPool builtPool : loot.builtItems) {
                for (ConditionalStack stack : builtPool.stacks()) {
                    if (stack.weight() < 100.0f) {
                        allStacksGuaranteed = false;
                    }
                    itemStackList.addAll(stack.getRawStacks());
                }
                if (loot.isSimple) {
                    BlockLootRecipeData.addSimpleWidgetBuilder(rowBuilderList, builtPool);
                    continue;
                }
                BlockLootRecipeData.addWidgetBuilders(rowBuilderList, builtPool, false);
            }
            class_2960 id = new class_2960("emi_loot", "/" + EmiClientPlugin.BLOCK_CATEGORY.id.method_12832() + "/" + loot.id.method_12836() + "/" + loot.id.method_12832());
            InitializedSupplier<List<EmiStack>> outputStacks = new InitializedSupplier<List<EmiStack>>(() -> {
                ArrayList<EmiStack> list = new ArrayList<EmiStack>();
                for (class_1799 stack : itemStackList) {
                    list.add(EmiStack.of((class_1799)stack));
                }
                return list;
            });
            InitializedSupplier<EmiStack> inputStack = new InitializedSupplier<EmiStack>(() -> block.method_8389() == class_1802.field_8162 ? new BlockStateEmiStack(block.method_9564(), blockId) : EmiStack.of((class_1935)block));
            return new BlockLootRecipeData(id, rowBuilderList, allStacksGuaranteed || loot.isSimple, inputStack, outputStacks);
        }

        private static void addSimpleWidgetBuilder(List<WidgetRowBuilder> rowBuilderList, ClientBuiltPool newPool) {
            WidgetRowBuilder builder = new WidgetRowBuilder(115);
            builder.addSimple(newPool);
            rowBuilderList.add(builder);
        }

        private static void addWidgetBuilders(List<WidgetRowBuilder> rowBuilderList, ClientBuiltPool newPool, boolean recursive) {
            WidgetRowBuilder builder;
            boolean newBuilder = false;
            if (recursive || rowBuilderList.isEmpty()) {
                builder = new WidgetRowBuilder(115);
                newBuilder = true;
            } else {
                builder = rowBuilderList.get(rowBuilderList.size() - 1);
            }
            Optional<ClientBuiltPool> opt = builder.addAndTrim(newPool);
            if (newBuilder) {
                rowBuilderList.add(builder);
            }
            opt.ifPresent(clientMobBuiltPool -> BlockLootRecipeData.addWidgetBuilders(rowBuilderList, clientMobBuiltPool, true));
        }
    }
}

