/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootAgnos;
import fzzyhmstrs.emi_loot.EMILootClientAgnos;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.client.ClientGameplayLootTable;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.ConditionalStack;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.IconGroupEmiWidget;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.SymbolText;
import fzzyhmstrs.emi_loot.util.TrimmedTitle;
import fzzyhmstrs.emi_loot.util.WidgetRowBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class GameplayLootRecipe
implements EmiRecipe {
    private final ClientGameplayLootTable loot;
    private final List<EmiStack> outputStacks;
    private final TrimmedTitle name;
    private final List<WidgetRowBuilder> rowBuilderList = new ArrayList<WidgetRowBuilder>();

    public GameplayLootRecipe(GameplayLootRecipeData data) {
        this.loot = data.loot;
        ArrayList<EmiStack> list = new ArrayList<EmiStack>();
        data.loot.builtItems.forEach(builtPool -> {
            builtPool.stacks().forEach(stack -> list.addAll(stack.getStacks()));
            this.addWidgetBuilders((ClientBuiltPool)builtPool, false);
        });
        this.outputStacks = list;
        this.name = data.name;
    }

    private void addWidgetBuilders(ClientBuiltPool newPool, boolean recursive) {
        if (recursive || this.rowBuilderList.isEmpty()) {
            this.rowBuilderList.add(new WidgetRowBuilder(154));
        }
        boolean added = false;
        for (WidgetRowBuilder builder : this.rowBuilderList) {
            if (!builder.canAddPool(newPool)) continue;
            builder.addAndTrim(newPool);
            added = true;
            break;
        }
        if (!added) {
            Optional<ClientBuiltPool> opt = this.rowBuilderList.get(this.rowBuilderList.size() - 1).addAndTrim(newPool);
            opt.ifPresent(clientMobBuiltPool -> this.addWidgetBuilders((ClientBuiltPool)clientMobBuiltPool, true));
        }
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.GAMEPLAY_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return new class_2960("emi_loot", "/" + this.getCategory().id.method_12832() + "/" + this.loot.id.method_12836() + "/" + this.loot.id.method_12832());
    }

    public List<EmiIngredient> getInputs() {
        return new ArrayList<EmiIngredient>();
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputStacks;
    }

    public int getDisplayWidth() {
        return EMILoot.config.isTooltipStyle() ? 144 : 154;
    }

    public int getDisplayHeight() {
        if (EMILoot.config.isTooltipStyle()) {
            int stacks = this.outputStacks.size();
            if (stacks <= 8) {
                return 29;
            }
            if (EMILoot.config.isCompact(EMILoot.Type.GAMEPLAY)) {
                int ingredients = 0;
                for (WidgetRowBuilder builder : this.rowBuilderList) {
                    ingredients += builder.ingredientCount();
                }
                if (ingredients <= 8) {
                    return 29;
                }
                return 11 + 18 * ((ingredients + 7) / 8);
            }
            return 11 + 18 * ((stacks + 7) / 8);
        }
        return this.rowBuilderList.size() * 29 + 11;
    }

    public void addWidgets(WidgetHolder widgets) {
        int x = 0;
        int y = 0;
        widgets.addText(this.name.title(), 0, 0, 0x404040, false);
        if (EMILootAgnos.isModLoaded(this.loot.id.method_12836())) {
            widgets.addTooltip(LText.components(this.name.rawTitle(), this.loot.id.method_12836()), 0, 0, 144, 10);
        } else {
            widgets.addTooltipText(List.of(this.name.rawTitle()), 0, 0, 144, 10);
        }
        if (EMILoot.config.isTooltipStyle()) {
            List stacks = this.outputStacks.size() <= 4 || !EMILoot.config.isCompact(EMILoot.Type.GAMEPLAY) ? (List)this.rowBuilderList.stream().map(WidgetRowBuilder::stacks).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll) : (List)this.rowBuilderList.stream().map(WidgetRowBuilder::ingredients).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
            int i = 0;
            int j = 0;
            for (ConditionalStack stack : stacks) {
                SlotWidget widget = widgets.addSlot(stack.getIngredient(), i * 18, 11 + 18 * j);
                String rounded = FloatTrimmer.trimFloatString(stack.weight() / 100.0f, (Integer)EMILoot.config.chanceDecimalPlaces.get());
                widget.appendTooltip((class_2561)FcText.INSTANCE.translatable("emi_loot.rolls", new Object[]{rounded}).method_27692(class_124.field_1080));
                if (EMILoot.config.isNotPlain()) {
                    for (class_3545<Integer, class_2561> pair : stack.conditions()) {
                        widget.appendTooltip((class_2561)SymbolText.of((Integer)pair.method_15442(), (class_2561)pair.method_15441()));
                    }
                }
                if (++i <= 7) continue;
                i = 0;
                ++j;
            }
        } else {
            y += 11;
            for (WidgetRowBuilder builder : this.rowBuilderList) {
                for (ClientBuiltPool pool : builder.getPoolList()) {
                    IconGroupEmiWidget widget = EMILootClientAgnos.createIconGroupEmiWidget(x, y, pool);
                    widgets.add((Widget)widget);
                    x += widget.getWidth() + 6;
                }
                y += 29;
                x = 0;
            }
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }

    public record GameplayLootRecipeData(ClientGameplayLootTable loot, TrimmedTitle name) {
        public static GameplayLootRecipeData of(ClientGameplayLootTable loot) {
            class_5250 rawTitle;
            loot.build((class_1937)class_310.method_1551().field_1687, class_2246.field_10124);
            String key = "emi_loot.gameplay." + loot.id.toString();
            if (!class_1074.method_4663((String)key)) {
                String[] chestPathTokens;
                StringBuilder gameplayName = new StringBuilder();
                for (String str : chestPathTokens = loot.id.method_12832().split("[/_]")) {
                    if (!gameplayName.isEmpty()) {
                        gameplayName.append(" ");
                    }
                    if (str.length() <= 1) {
                        gameplayName.append(str);
                        continue;
                    }
                    gameplayName.append(str.substring(0, 1).toUpperCase()).append(str.substring(1));
                }
                if (EMILootAgnos.isModLoaded(loot.id.method_12836())) {
                    rawTitle = LText.translatable("emi_loot.gameplay.unknown_gameplay", gameplayName.toString());
                } else {
                    class_5250 unknown = LText.translatable("emi_loot.gameplay.unknown");
                    rawTitle = LText.translatable("emi_loot.gameplay.unknown_gameplay", LText.literal(gameplayName.toString()).method_27693(" ").method_10852((class_2561)unknown));
                }
                if (EMILoot.config.isLogI18n(EMILoot.Type.GAMEPLAY)) {
                    EMILoot.LOGGER.warn("Untranslated gameplay loot table \"{}\" (key: \"{}\")", (Object)loot.id, (Object)key);
                }
            } else {
                rawTitle = LText.translatable(key);
            }
            TrimmedTitle name = TrimmedTitle.of((class_2561)rawTitle, EMILoot.config.isTooltipStyle() ? 138 : 148);
            return new GameplayLootRecipeData(loot, name);
        }
    }
}

