/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser.processor;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.BinomialLootNumberProviderAccessor;
import fzzyhmstrs.emi_loot.mixins.BoundedIntUnaryOperatorAccessor;
import fzzyhmstrs.emi_loot.mixins.ConstantLootNumberProviderAccessor;
import fzzyhmstrs.emi_loot.mixins.ScoreLootNumberProviderAccessor;
import fzzyhmstrs.emi_loot.mixins.UniformLootNumberProviderAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.Objects;
import net.minecraft.class_2096;
import net.minecraft.class_42;
import net.minecraft.class_5250;
import net.minecraft.class_5657;
import net.minecraft.class_5658;
import net.minecraft.class_5659;

public class NumberProcessors {
    public static class_5250 processBoolean(Boolean input, String keyTrue, String keyFalse, Object ... args) {
        if (input != null) {
            if (input.booleanValue()) {
                return LText.translatable(keyTrue, args);
            }
            return LText.translatable(keyFalse, args);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Boolean null for keys: " + keyTrue + " / " + keyFalse + " in table: " + LootTableParser.currentTable);
        }
        return LText.empty();
    }

    public static class_5250 processNumberRange(class_2096<?> range, String exact, String between, String atLeast, String atMost, String fallback, Object ... args) {
        if (!range.equals((Object)class_2096.class_2100.field_9708) && !range.equals((Object)class_2096.class_2099.field_9705)) {
            Number max;
            Number min = range.method_9038();
            if (Objects.equals(min, max = range.method_9042()) && min != null) {
                return LText.translatable(exact, min, args);
            }
            if (min != null && max != null) {
                return LText.translatable(between, min, max, args);
            }
            if (min != null) {
                return LText.translatable(atLeast, min, args);
            }
            if (max != null) {
                return LText.translatable(atMost, max, args);
            }
            if (fallback.equals("")) {
                return LText.empty();
            }
            return LText.translatable(fallback);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Non-specific number range for keys: " + exact + " / " + between + " in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static class_5250 processBoundedIntUnaryOperator(class_42 operator) {
        class_5658 min = ((BoundedIntUnaryOperatorAccessor)operator).getMin();
        class_5658 max = ((BoundedIntUnaryOperatorAccessor)operator).getMax();
        if (min != null && max != null) {
            float maxVal;
            float minVal;
            if (min.method_365() == class_5659.field_27921 && max.method_365() == class_5659.field_27921 && (minVal = ((ConstantLootNumberProviderAccessor)min).getValue()) == (maxVal = ((ConstantLootNumberProviderAccessor)max).getValue())) {
                return NumberProcessors.processLootNumberProvider(min);
            }
            return LText.translatable("emi_loot.operator.between", NumberProcessors.processLootNumberProvider(min), NumberProcessors.processLootNumberProvider(max));
        }
        if (min != null) {
            return LText.translatable("emi_loot.operator.min", NumberProcessors.processLootNumberProvider(min));
        }
        if (max != null) {
            return LText.translatable("emi_loot.operator.max", NumberProcessors.processLootNumberProvider(max));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Null or undefined bounded int unary operator in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.operator.unknown");
    }

    public static class_5250 processLootNumberProvider(class_5658 provider) {
        class_5657 type = provider.method_365();
        if (type == class_5659.field_27921) {
            return LText.translatable("emi_loot.number_provider.constant", Float.valueOf(((ConstantLootNumberProviderAccessor)provider).getValue()));
        }
        if (type == class_5659.field_27923) {
            class_5658 n = ((BinomialLootNumberProviderAccessor)provider).getN();
            class_5658 p = ((BinomialLootNumberProviderAccessor)provider).getP();
            float nVal = NumberProcessors.getRollAvg(n);
            float pVal = NumberProcessors.getRollAvg(p);
            class_5250 nValText = NumberProcessors.processLootNumberProvider(n);
            class_5250 pValText = NumberProcessors.processLootNumberProvider(p);
            float avg = nVal * pVal;
            return LText.translatable("emi_loot.number_provider.binomial", nValText, pValText, Float.valueOf(avg));
        }
        if (type == class_5659.field_27922) {
            class_5658 min = ((UniformLootNumberProviderAccessor)provider).getMin();
            class_5658 max = ((UniformLootNumberProviderAccessor)provider).getMax();
            float minVal = NumberProcessors.getRollAvg(min);
            float maxVal = NumberProcessors.getRollAvg(max);
            class_5250 minValText = NumberProcessors.processLootNumberProvider(min);
            class_5250 maxValText = NumberProcessors.processLootNumberProvider(max);
            float avg = (minVal + maxVal) / 2.0f;
            return LText.translatable("emi_loot.number_provider.uniform", minValText, maxValText, Float.valueOf(avg));
        }
        if (type == class_5659.field_27924) {
            String lootScore = ((ScoreLootNumberProviderAccessor)provider).getScore();
            float lootScale = ((ScoreLootNumberProviderAccessor)provider).getScale();
            return LText.translatable("emi_loot.number_provider.score", lootScore, Float.valueOf(lootScale));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Non-specific or undefined number provider in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.number_provider.unknown");
    }

    public static float getRollAvg(class_5658 provider) {
        class_5657 type = provider.method_365();
        if (type == class_5659.field_27921) {
            return ((ConstantLootNumberProviderAccessor)provider).getValue();
        }
        if (type == class_5659.field_27923) {
            class_5658 n = ((BinomialLootNumberProviderAccessor)provider).getN();
            class_5658 p = ((BinomialLootNumberProviderAccessor)provider).getP();
            float nVal = NumberProcessors.getRollAvg(n);
            float pVal = NumberProcessors.getRollAvg(p);
            return nVal * pVal;
        }
        if (type == class_5659.field_27922) {
            class_5658 min = ((UniformLootNumberProviderAccessor)provider).getMin();
            class_5658 max = ((UniformLootNumberProviderAccessor)provider).getMax();
            float minVal = NumberProcessors.getRollAvg(min);
            float maxVal = NumberProcessors.getRollAvg(max);
            return (minVal + maxVal) / 2.0f;
        }
        if (type == class_5659.field_27924) {
            return 0.0f;
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Loot number provider with unknown type: " + provider.method_365().toString());
        }
        return 0.0f;
    }
}

