/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.mixin.accessor.BakedModelManagerAccessor;
import dev.emi.emi.mixin.accessor.ItemRendererAccessor;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.tooltip.EmiTextTooltipWrapper;
import dev.emi.emi.screen.tooltip.RemainderTooltipComponent;
import dev.emi.emi.screen.tooltip.TagTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_6862;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

@ApiStatus.Internal
public class TagEmiIngredient
implements EmiIngredient {
    private final class_2960 id;
    private List<EmiStack> stacks;
    public final class_6862<?> key;
    private long amount;
    private float chance = 1.0f;

    @ApiStatus.Internal
    public TagEmiIngredient(class_6862<?> key, long amount) {
        this(key, EmiTags.getValues(key), amount);
    }

    @ApiStatus.Internal
    public TagEmiIngredient(class_6862<?> key, List<EmiStack> stacks, long amount) {
        this.id = key.comp_327();
        this.key = key;
        this.stacks = stacks;
        this.amount = amount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TagEmiIngredient)) return false;
        TagEmiIngredient tag = (TagEmiIngredient)obj;
        if (!tag.key.equals(this.key)) return false;
        return true;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public EmiIngredient copy() {
        TagEmiIngredient stack = new TagEmiIngredient(this.key, this.amount);
        stack.setChance(this.chance);
        return stack;
    }

    @Override
    public List<EmiStack> getEmiStacks() {
        return this.stacks;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public EmiIngredient setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public EmiIngredient setChance(float chance) {
        this.chance = chance;
        return this;
    }

    @Override
    public void render(class_332 draw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        class_310 client = class_310.method_1551();
        if ((flags & 1) != 0) {
            if (!EmiTags.hasCustomModel(this.key)) {
                if (this.stacks.size() > 0) {
                    this.stacks.get(0).render(context.raw(), x, y, delta, -3);
                }
            } else {
                class_1087 model = ((BakedModelManagerAccessor)client.method_1554()).getModels().getOrDefault(EmiTags.getCustomModel(this.key), client.method_1554().method_4744());
                context.matrices().method_22903();
                context.matrices().method_46416((float)(x + 8), (float)(y + 8), 150.0f);
                context.matrices().method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                context.matrices().method_22905(16.0f, 16.0f, 16.0f);
                model.method_4709().method_3503(class_811.field_4317).method_23075(false, context.matrices());
                context.matrices().method_46416(-0.5f, -0.5f, -0.5f);
                if (!model.method_24304()) {
                    class_308.method_24210();
                }
                class_4597.class_4598 immediate = context.raw().method_51450();
                ((ItemRendererAccessor)client.method_1480()).invokeRenderBakedItemModel(model, class_1799.field_8037, 0xF000F0, class_4608.field_21444, context.matrices(), class_918.method_29711((class_4597)immediate, (class_1921)class_4722.method_24076(), (boolean)true, (boolean)false));
                immediate.method_22993();
                if (!model.method_24304()) {
                    class_308.method_24211();
                }
                context.matrices().method_22909();
            }
        }
        if ((flags & 2) != 0 && !this.key.comp_326().equals(EmiPort.getFluidRegistry().method_30517())) {
            Object count = "";
            if (this.amount != 1L) {
                count = (String)count + this.amount;
            }
            EmiRenderHelper.renderAmount(context, x, y, (class_2561)EmiPort.literal((String)count));
        }
        if ((flags & 4) != 0) {
            EmiRender.renderTagIcon(this, context.raw(), x, y);
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon(this, context.raw(), x, y);
        }
    }

    @Override
    public List<class_5684> getTooltip() {
        ArrayList list = Lists.newArrayList();
        list.add(new EmiTextTooltipWrapper((EmiIngredient)this, EmiPort.ordered(EmiTags.getTagName(this.key))));
        if (EmiUtil.showAdvancedTooltips()) {
            list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.literal("#" + String.valueOf(this.id), class_124.field_1063))));
        }
        if (this.key.comp_326().equals(EmiPort.getFluidRegistry().method_30517()) && this.amount > 1L) {
            list.add(class_5684.method_32662((class_5481)EmiPort.ordered(EmiRenderHelper.getAmountText((EmiIngredient)this, this.amount))));
        }
        if (EmiConfig.appendModId) {
            String mod = EmiUtil.getModName(this.id.method_12836());
            list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.literal(mod, class_124.field_1078, class_124.field_1056))));
        }
        list.add(new TagTooltipComponent(this.stacks));
        for (EmiStack stack : this.stacks) {
            if (stack.getRemainder().isEmpty()) continue;
            list.add(new RemainderTooltipComponent(this));
            break;
        }
        return list;
    }
}

