/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.mixin;

import com.google.common.collect.Ordering;
import dev.emi.emi.config.EffectLocation;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_485;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_485.class})
public abstract class AbstractInventoryScreenMixin<T extends class_1703>
extends class_465<T> {
    @Unique
    private static boolean hasInventoryTabs = EmiAgnos.isModLoaded("inventorytabs");

    private AbstractInventoryScreenMixin() {
        super(null, null, null);
    }

    @Shadow
    private class_2561 method_38933(class_1293 effect) {
        throw new UnsupportedOperationException();
    }

    @Shadow
    private void method_18642(class_332 draw, int x, int height, Iterable<class_1293> statusEffects, boolean wide) {
        throw new UnsupportedOperationException();
    }

    @Shadow
    private void method_18643(class_332 draw, int x, int height, Iterable<class_1293> statusEffects, boolean wide) {
        throw new UnsupportedOperationException();
    }

    @Shadow
    private void method_18644(class_332 draw, int x, int height, Iterable<class_1293> statusEffects) {
        throw new UnsupportedOperationException();
    }

    @Inject(at={@At(value="INVOKE", target="net/minecraft/client/gui/screen/ingame/AbstractInventoryScreen.drawStatusEffectBackgrounds(Lnet/minecraft/client/gui/DrawContext;IILjava/lang/Iterable;Z)V")}, method={"drawStatusEffects"})
    private void drawStatusEffects(class_332 draw, int mouseX, int mouseY, CallbackInfo info) {
        if (EmiConfig.effectLocation == EffectLocation.TOP) {
            this.emi$drawCenteredEffects(draw, mouseX, mouseY);
        }
    }

    @ModifyVariable(at=@At(value="INVOKE", target="java/util/Collection.size()I", ordinal=0), method={"drawStatusEffects"}, ordinal=0)
    private Collection<class_1293> drawStatusEffects(Collection<class_1293> original) {
        if (EmiConfig.effectLocation == EffectLocation.TOP || EmiConfig.effectLocation == EffectLocation.HIDDEN) {
            return List.of();
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emi$drawCenteredEffects(class_332 raw, int mouseX, int mouseY) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        context.resetColor();
        List effects = Ordering.natural().sortedCopy((Iterable)this.field_22787.field_1724.method_6026());
        int size = effects.size();
        if (size == 0) {
            return;
        }
        boolean wide = size == 1;
        int y = this.field_2800 - 34;
        if (this instanceof class_481 || hasInventoryTabs) {
            y -= 28;
            if (this instanceof class_481 && EmiAgnos.isForge()) {
                y -= 22;
            }
        }
        int xOff = 34;
        if (wide) {
            xOff = 122;
        } else if (size > 5) {
            xOff = (this.field_2792 - 32) / (size - 1);
        }
        int width = (size - 1) * xOff + (wide ? 120 : 32);
        int x = this.field_2776 + (this.field_2792 - width) / 2;
        class_1293 hovered = null;
        int restoreY = this.field_2800;
        try {
            this.field_2800 = y;
            for (class_1293 inst : effects) {
                int ew = wide ? 120 : 32;
                List<class_1293> single = List.of(inst);
                this.method_18642(context.raw(), x, 32, single, wide);
                this.method_18643(context.raw(), x, 32, single, wide);
                if (wide) {
                    this.method_18644(context.raw(), x, 32, single);
                }
                if (mouseX >= x && mouseX < x + ew && mouseY >= y && mouseY < y + 32) {
                    hovered = inst;
                }
                x += xOff;
            }
        }
        finally {
            this.field_2800 = restoreY;
        }
        if (hovered != null && size > 1) {
            List<class_2561> list = List.of(this.method_38933(hovered), class_1292.method_5577(hovered, (float)1.0f));
            context.raw().method_51437(this.field_22787.field_1772, list, Optional.empty(), mouseX, Math.max(mouseY, 16));
        }
    }

    @ModifyVariable(at=@At(value="STORE", ordinal=0), method={"drawStatusEffects"}, ordinal=0)
    private boolean squishEffects(boolean original) {
        return !EmiConfig.effectLocation.compressed;
    }

    @ModifyVariable(at=@At(value="STORE", ordinal=0), method={"drawStatusEffects"}, ordinal=2)
    private int changeEffectSpace(int original) {
        return switch (EmiConfig.effectLocation) {
            default -> throw new IncompatibleClassChangeError();
            case EffectLocation.RIGHT, EffectLocation.RIGHT_COMPRESSED, EffectLocation.HIDDEN -> original;
            case EffectLocation.TOP -> this.field_2776;
            case EffectLocation.LEFT_COMPRESSED -> this.field_2776 - 2 - 32;
            case EffectLocation.LEFT -> this.field_2776 - 2 - 120;
        };
    }
}

