/*
 * Decompiled with CFR 0.152.
 */
package moe.prwk.emiffect.util.resources;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import moe.prwk.emiffect.EMIffectPlugin;
import moe.prwk.emiffect.util.VersionUtil;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.jetbrains.annotations.NotNull;

public class ExtraAppenderLoader
extends class_4080<List<ExtraAppender>> {
    private static final Gson GSON = new Gson();
    private static List<ExtraAppender> APPENDERS = List.of();

    @NotNull
    protected List<ExtraAppender> prepare(class_3300 manager, class_3695 profiler) {
        ArrayList<ExtraAppender> ret = new ArrayList<ExtraAppender>();
        for (class_2960 id : EmiPort.findResources((class_3300)manager, (String)"emiffect/extra_stacks", i -> i.endsWith(".json"))) {
            try {
                for (class_3298 resource : manager.method_14489(id)) {
                    InputStreamReader reader = new InputStreamReader(EmiPort.getInputStream((class_3298)resource));
                    JsonObject json = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                    class_2960 effectId = VersionUtil.identifier(json.get("id").getAsString());
                    List ingredients = json.get("stacks").getAsJsonArray().asList();
                    ret.add(new ExtraAppender(effectId, ingredients));
                    EMIffectPlugin.LOGGER.info("Added extra stack appender for effect with ID: {}", (Object)effectId);
                }
            }
            catch (Exception e) {
                EMIffectPlugin.LOGGER.error("Failed to load extra stack appender", (Throwable)e);
            }
        }
        return ret;
    }

    protected void apply(List<ExtraAppender> prepared, class_3300 manager, class_3695 profiler) {
        APPENDERS = prepared;
    }

    public static List<ExtraAppender> getAppenders() {
        return APPENDERS;
    }

    public record ExtraAppender(class_2960 effectId, List<JsonElement> ingredients) {
        public List<EmiIngredient> getIngredients() {
            return this.ingredients.stream().map(EmiIngredientSerializer::getDeserialized).toList();
        }
    }
}

