/*
 * Decompiled with CFR 0.152.
 */
package lv.enes.mc.eris_alchemy;

import jakarta.annotation.Nullable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lv.enes.mc.eris_alchemy.ErisAlchemy;
import lv.enes.mc.eris_alchemy.ErisAlchemyRegistry;
import lv.enes.mc.eris_alchemy.block.EmcStorageBlock;
import lv.enes.mc.eris_alchemy.recipe.BannedRecipe;
import lv.enes.mc.eris_alchemy.recipe.SimplifiedRecipe;
import lv.enes.mc.eris_alchemy.utils.BufUtils;
import lv.enes.mc.eris_alchemy.utils.ConsList;
import lv.enes.mc.eris_alchemy.utils.ForeignUtils;
import lv.enes.mc.eris_alchemy.utils.ItemUtils;
import lv.enes.mc.eris_alchemy.utils.OptionalDoubleSummer;
import lv.enes.mc.eris_alchemy.utils.PlayerUtils;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.quiltmc.loader.api.minecraft.ClientOnly;
import org.quiltmc.qsl.networking.api.PacketByteBufs;
import org.quiltmc.qsl.networking.api.ServerPlayConnectionEvents;
import org.quiltmc.qsl.networking.api.ServerPlayNetworking;
import org.quiltmc.qsl.networking.api.client.ClientPlayNetworking;

public final class Emc {
    private static final Map<class_2960, OptionalDouble> ITEM_VALUES = new HashMap<class_2960, OptionalDouble>();
    private static final Map<class_6862<class_1792>, OptionalDouble> ITEM_TAG_VALUES = new HashMap<class_6862<class_1792>, OptionalDouble>();
    private static final Map<class_6862<class_2248>, OptionalDouble> BLOCK_TAG_VALUES = new HashMap<class_6862<class_2248>, OptionalDouble>();
    private static final List<SimplifiedRecipe> FAKE_RECIPES = new ArrayList<SimplifiedRecipe>();
    private static final List<BannedRecipe> BANNED_RECIPES = new ArrayList<BannedRecipe>();
    private static final Map<class_2960, OptionalDouble> VALUES = Collections.synchronizedMap(new HashMap());
    private static final DecimalFormat FORMATTER = new DecimalFormat("0");
    private static class_3218 overworld;

    private Emc() {
    }

    public static String formatEmc(double value) {
        return FORMATTER.format(value);
    }

    public static OptionalDouble get(class_1799 stack) {
        if (stack.method_7960()) {
            return OptionalDouble.empty();
        }
        class_1792 item = stack.method_7909();
        class_2960 itemId = ItemUtils.getId((class_1935)item);
        return Emc.get(itemId).stream().map(value -> {
            class_1747 blockItem;
            class_2248 patt2768$temp;
            if (item instanceof class_1747 && (patt2768$temp = (blockItem = (class_1747)item).method_7711()) instanceof EmcStorageBlock) {
                EmcStorageBlock block = (EmcStorageBlock)patt2768$temp;
                return value + block.getStoredEmc(stack);
            }
            return value;
        }).findFirst();
    }

    public static OptionalDouble getTotal(class_1799 stack) {
        return Emc.get(stack).stream().map(x -> x * (double)stack.method_7947()).filter(x -> x > 0.0).findFirst();
    }

    public static OptionalDouble get(class_2960 itemId) {
        return VALUES.getOrDefault(itemId, OptionalDouble.empty());
    }

    @ClientOnly
    public static void initClient(class_310 ignoredClient) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ErisAlchemyRegistry.NetworkingConstants.UPDATE_EMCS, (client, handler, buf, responseSender) -> Emc.syncFrom(buf));
    }

    public static void initServer(MinecraftServer server) {
        overworld = server.method_30002();
        Emc.reinit();
        Emc.warnOfMissingValues();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server1) -> Emc.syncTo(handler.method_32311()));
    }

    public static void reloadData(Map<class_2960, OptionalDouble> itemValues, Map<class_2960, OptionalDouble> itemTagValues, Map<class_2960, OptionalDouble> blockTagValues, List<SimplifiedRecipe> fakeRecipes, List<BannedRecipe> bannedRecipes) {
        ITEM_VALUES.clear();
        ITEM_VALUES.putAll(itemValues);
        ITEM_TAG_VALUES.clear();
        itemTagValues.forEach((id, value) -> ITEM_TAG_VALUES.put((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id), (OptionalDouble)value));
        BLOCK_TAG_VALUES.clear();
        blockTagValues.forEach((id, value) -> BLOCK_TAG_VALUES.put((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)id), (OptionalDouble)value));
        FAKE_RECIPES.clear();
        FAKE_RECIPES.addAll(fakeRecipes);
        BANNED_RECIPES.clear();
        BANNED_RECIPES.addAll(bannedRecipes);
        Emc.reinit();
        Emc.warnOfMissingValues();
    }

    private static OptionalDouble calcEmc(class_2960 item, Map<class_2960, List<SimplifiedRecipe>> allRecipes) {
        return allRecipes.getOrDefault(item, List.of()).stream().map(Emc::calcEmcForRecipe).flatMapToDouble(OptionalDouble::stream).average();
    }

    private static OptionalDouble calcEmcForIngredient(class_1856 ingredient) {
        return Arrays.stream(ingredient.method_8105()).map(Emc::getTotal).flatMapToDouble(OptionalDouble::stream).average();
    }

    private static OptionalDouble calcEmcForRecipe(SimplifiedRecipe recipe) {
        if (recipe.input().isEmpty()) {
            return OptionalDouble.empty();
        }
        OptionalDouble inputEmcOpt = recipe.input().stream().map(Supplier::get).map(Emc::calcEmcForIngredient).collect(new OptionalDoubleSummer());
        if (inputEmcOpt.isEmpty()) {
            return OptionalDouble.empty();
        }
        OptionalDouble remainderEmcOpt = recipe.remainder().stream().map(Emc::getTotal).collect(new OptionalDoubleSummer());
        if (remainderEmcOpt.isEmpty()) {
            return OptionalDouble.empty();
        }
        double inputEmc = inputEmcOpt.getAsDouble();
        double remainderEmc = remainderEmcOpt.getAsDouble();
        if (remainderEmc > inputEmc) {
            ErisAlchemy.LOGGER.warn("Recipe generating {} creates too much EMC out of thin air!", (Object)recipe.output());
            return OptionalDouble.empty();
        }
        double outputDivisor = recipe.output().method_7947();
        return OptionalDouble.of((inputEmc - remainderEmc) / outputDivisor);
    }

    private static Stream<SimplifiedRecipe> getRecipes(@Nullable class_1937 world) {
        Stream<SimplifiedRecipe> recipes = FAKE_RECIPES.stream();
        if (world != null) {
            recipes = Stream.concat(recipes, world.method_8433().method_8126().stream().map(recipe -> SimplifiedRecipe.of(recipe, world.method_30349())).flatMap(Collection::stream));
        }
        return recipes;
    }

    private static void reinit() {
        VALUES.clear();
        VALUES.putAll(ITEM_VALUES);
        ITEM_TAG_VALUES.forEach((tag, emcValue) -> class_7923.field_41178.method_40286(tag).forEach(holder -> VALUES.putIfAbsent(ItemUtils.getId(holder), (OptionalDouble)emcValue)));
        BLOCK_TAG_VALUES.forEach((tag, emcValue) -> class_7923.field_41175.method_40286(tag).forEach(holder -> VALUES.putIfAbsent(ItemUtils.getId(holder), (OptionalDouble)emcValue)));
        ErisAlchemy.LOGGER.info("Calculating EMC values from recipes...");
        HashMap<class_2960, List<SimplifiedRecipe>> recipes = new HashMap<class_2960, List<SimplifiedRecipe>>();
        Emc.getRecipes((class_1937)overworld).filter(recipe -> !recipe.hasDuplication()).filter(recipe -> recipe.isAllowed(BANNED_RECIPES)).forEach(recipe -> recipes.computeIfAbsent(ItemUtils.getId(recipe.output()), k -> new ArrayList()).add(recipe));
        Set<class_2960> sortedItems = Emc.sorted(recipes);
        sortedItems.stream().filter(id -> !VALUES.containsKey(id)).forEach(id -> Emc.calcEmc(id, recipes).ifPresent(v -> VALUES.put((class_2960)id, OptionalDouble.of(v))));
        if (ForeignUtils.isClassAvailable("earth.terrarium.chipped.common.recipes.ChippedRecipe")) {
            Emc.reinitForChipped(sortedItems, recipes);
        }
        ErisAlchemy.LOGGER.info("Done calculating EMC values...");
        Emc.sync();
    }

    private static void reinitForChipped(Set<class_2960> items, HashMap<class_2960, List<SimplifiedRecipe>> recipes) {
        items.stream().filter(id -> !VALUES.containsKey(id)).forEach(item -> {
            List<SimplifiedRecipe> myRecipes = recipes.getOrDefault(item, List.of()).stream().filter(SimplifiedRecipe::fromChipped).toList();
            if (myRecipes.size() != 1) {
                if (!myRecipes.isEmpty()) {
                    ErisAlchemy.LOGGER.warn("Item {} has multiple chipped recipes, skipping...", item);
                }
                return;
            }
            SimplifiedRecipe recipe = myRecipes.get(0);
            if (recipe.input().size() != 1) {
                ErisAlchemy.LOGGER.warn("Chipped recipe for {} has multiple inputs, skipping...", item);
                return;
            }
            class_1799[] stacks = recipe.input().get(0).get().method_8105();
            if (stacks.length != 1) {
                ErisAlchemy.LOGGER.warn("Chipped recipe for {} has multiple stack inputs, skipping...", item);
                return;
            }
            class_2960 inputId = ItemUtils.getId(stacks[0]);
            if (VALUES.containsKey(inputId)) {
                VALUES.put((class_2960)item, VALUES.get(inputId));
            }
        });
    }

    private static void sortDps(Set<class_2960> permSorted, ConsList<class_2960> tmpSorted, class_2960 item, Map<class_2960, List<SimplifiedRecipe>> data) {
        if (permSorted.contains(item)) {
            return;
        }
        ConsList<class_2960> newTmpSorted = ConsList.cons(item, tmpSorted);
        if (tmpSorted.contains(item)) {
            ErisAlchemy.LOGGER.warn("Cycle in recipes detected: {}, breaking here", newTmpSorted);
            return;
        }
        data.getOrDefault(item, List.of()).stream().flatMap(SimplifiedRecipe::dependencies).distinct().forEach(dep -> Emc.sortDps(permSorted, newTmpSorted, dep, data));
        permSorted.add(item);
    }

    private static Set<class_2960> sorted(Map<class_2960, List<SimplifiedRecipe>> unsorted) {
        LinkedHashSet<class_2960> res = new LinkedHashSet<class_2960>();
        unsorted.forEach((item, recipes) -> Emc.sortDps(res, ConsList.nil(), item, unsorted));
        return res;
    }

    private static void sync() {
        Emc.syncTo(PlayerUtils.all());
    }

    private static void syncFrom(class_2540 buf) {
        Map map = buf.method_34067(class_2540::method_10810, BufUtils::readOptionalDouble);
        VALUES.clear();
        VALUES.putAll(map);
    }

    private static class_2540 syncTo(class_2540 buf) {
        buf.method_34063(VALUES, class_2540::method_10812, BufUtils::writeOptionalDouble);
        return buf;
    }

    private static void syncTo(Collection<class_3222> players) {
        class_2540 buf = Emc.syncTo(PacketByteBufs.create());
        ServerPlayNetworking.send(players, (class_2960)ErisAlchemyRegistry.NetworkingConstants.UPDATE_EMCS, (class_2540)buf);
    }

    private static void syncTo(class_3222 player) {
        class_2540 buf = Emc.syncTo(PacketByteBufs.create());
        ServerPlayNetworking.send((class_3222)player, (class_2960)ErisAlchemyRegistry.NetworkingConstants.UPDATE_EMCS, (class_2540)buf);
    }

    private static void warnOfMissingValues() {
        if (overworld == null) {
            return;
        }
        class_7923.field_41178.method_10235().stream().filter(item -> !VALUES.containsKey(item)).forEach(item -> ErisAlchemy.LOGGER.warn("No EMC value for '{}' known", item));
    }

    static {
        FORMATTER.setMaximumFractionDigits(1);
        overworld = null;
    }
}

