/*
 * Decompiled with CFR 0.152.
 */
package lv.enes.mc.eris_alchemy.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import lv.enes.mc.eris_alchemy.ErisAlchemyRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.quiltmc.qsl.recipe.api.serializer.QuiltRecipeSerializer;

public class CovalenceRepair
extends class_1852 {
    private static final int DUSTS_TO_FIX = 8;
    private final class_1856 dust;
    private final class_1856 materials;
    private final class_1856 tools;

    public CovalenceRepair(class_2960 id, class_7710 category, class_1856 dust, class_1856 materials, class_1856 tools) {
        super(id, category);
        this.dust = dust;
        this.materials = materials;
        this.tools = tools;
    }

    public boolean method_8113(int width, int height) {
        return width * height > 2;
    }

    public boolean matches(class_8566 inventory, class_1937 world) {
        return this.getInputs(inventory) != null;
    }

    @Nonnull
    public class_1799 assemble(class_8566 inventory, class_5455 registryManager) {
        Inputs inputs = this.getInputs(inventory);
        if (inputs == null) {
            return class_1799.field_8037;
        }
        class_1799 newToolStack = inputs.toolStack.method_7972();
        int repairedAmount = inputs.toolStack.method_7909().method_7841() * inputs.dustCount / 8;
        newToolStack.method_7974(inputs.toolStack.method_7919() - repairedAmount);
        return newToolStack;
    }

    @Nonnull
    public class_1865<CovalenceRepair> method_8119() {
        return ErisAlchemyRegistry.RecipeSerializers.COVALENCE_REPAIR;
    }

    private boolean isTool(class_1799 stack) {
        if (!stack.method_7963() || !stack.method_7986() || stack.method_7947() != 1) {
            return false;
        }
        if (this.tools.method_8093(stack)) {
            return true;
        }
        class_1792 item = stack.method_7909();
        return Arrays.stream(this.materials.method_8105()).anyMatch(material -> item.method_7878(stack, material));
    }

    private boolean isDust(class_1799 stack) {
        return this.dust.method_8093(stack);
    }

    private Inputs getInputs(class_8566 inventory) {
        class_1799 toolStack = null;
        ArrayList<class_1799> dustStacks = new ArrayList<class_1799>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            if (this.isDust(stack) && (dustStacks.isEmpty() || class_1799.method_31577((class_1799)((class_1799)dustStacks.get(0)), (class_1799)stack))) {
                dustStacks.add(stack);
                continue;
            }
            if (toolStack == null) {
                toolStack = stack;
                continue;
            }
            return null;
        }
        if (toolStack == null || dustStacks.isEmpty() || !this.isTool(toolStack)) {
            return null;
        }
        return new Inputs(toolStack, dustStacks.size());
    }

    private record Inputs(class_1799 toolStack, int dustCount) {
    }

    public static class Serializer
    implements QuiltRecipeSerializer<CovalenceRepair> {
        public JsonObject toJson(CovalenceRepair recipe) {
            JsonObject res = new JsonObject();
            res.addProperty("category", recipe.method_45441().toString());
            res.add("dust", recipe.dust.method_8089());
            res.add("materials", recipe.materials.method_8089());
            res.add("tools", recipe.tools.method_8089());
            return res;
        }

        @Nonnull
        public CovalenceRepair fromJson(class_2960 id, JsonObject json) {
            Json recipeJson = (Json)new Gson().fromJson((JsonElement)json, Json.class);
            if (recipeJson.dust == null) {
                throw new JsonSyntaxException("A required attribute is missing");
            }
            class_1856 dust = class_1856.method_52177((JsonElement)recipeJson.dust);
            class_1856 materials = class_1856.method_52177((JsonElement)recipeJson.materials);
            class_1856 tools = class_1856.method_52177((JsonElement)recipeJson.tools);
            return new CovalenceRepair(id, recipeJson.category, dust, materials, tools);
        }

        public void toNetwork(class_2540 buf, CovalenceRepair recipe) {
            buf.method_10817((Enum)recipe.method_45441());
            recipe.dust.method_8088(buf);
            recipe.materials.method_8088(buf);
            recipe.tools.method_8088(buf);
        }

        @Nonnull
        public CovalenceRepair fromNetwork(class_2960 id, class_2540 buf) {
            class_7710 category = (class_7710)buf.method_10818(class_7710.class);
            class_1856 dust = class_1856.method_8086((class_2540)buf);
            class_1856 materials = class_1856.method_8086((class_2540)buf);
            class_1856 tools = class_1856.method_8086((class_2540)buf);
            return new CovalenceRepair(id, category, dust, materials, tools);
        }

        private static class Json {
            class_7710 category = class_7710.field_40251;
            JsonElement dust;
            JsonElement materials = new JsonObject();
            JsonElement tools = new JsonObject();

            private Json() {
            }
        }
    }
}

