/*
 * Decompiled with CFR 0.152.
 */
package lv.enes.mc.eris_alchemy;

import com.google.gson.reflect.TypeToken;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import lv.enes.mc.eris_alchemy.Emc;
import lv.enes.mc.eris_alchemy.ErisAlchemy;
import lv.enes.mc.eris_alchemy.recipe.BannedRecipe;
import lv.enes.mc.eris_alchemy.recipe.SimplifiedRecipe;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.quiltmc.qsl.resource.loader.api.reloader.SimpleSynchronousResourceReloader;

public class EmcLoader
implements SimpleSynchronousResourceReloader {
    public static final EmcLoader INSTANCE = new EmcLoader();

    @Nonnull
    public class_2960 getQuiltId() {
        return new class_2960("eris_alchemy", "emc_loader");
    }

    public void method_14491(class_3300 manager) {
        HashMap itemValues = EmcLoader.loadAllFiles(manager, "item_emcs", new HashMap(), EmcLoader::loadEmcValues);
        HashMap itemTagValues = EmcLoader.loadAllFiles(manager, "item_tag_emcs", new HashMap(), EmcLoader::loadEmcValues);
        HashMap blockTagValues = EmcLoader.loadAllFiles(manager, "block_tag_emcs", new HashMap(), EmcLoader::loadEmcValues);
        ArrayList fakeRecipes = EmcLoader.loadAllFiles(manager, "fake_recipes", new ArrayList(), EmcLoader::loadFakeRecipes);
        ArrayList bannedRecipes = EmcLoader.loadAllFiles(manager, "cycle_cut", new ArrayList(), EmcLoader::loadBannedRecipes);
        Emc.reloadData(itemValues, itemTagValues, blockTagValues, fakeRecipes, bannedRecipes);
    }

    private static <T> T loadAllFiles(class_3300 manager, String path, T arg, Loader<T> loader) {
        manager.method_14488("eris_alchemy/" + path, loc -> loc.method_12832().endsWith(".json") || loc.method_12832().endsWith(".json5")).forEach((id, res) -> {
            ErisAlchemy.LOGGER.info("Loading {}:{}...", (Object)id.method_12836(), (Object)id.method_12832());
            try (InputStream is = res.method_14482();){
                loader.loadFile(arg, (class_2960)id, is);
            }
            catch (IOException e) {
                ErisAlchemy.LOGGER.error("Error occured while reading {}:{}", new Object[]{id.method_12836(), id.method_12832(), e});
            }
        });
        return arg;
    }

    private static void loadBannedRecipes(List<BannedRecipe> recipes, class_2960 id, InputStream is) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is);){
            List json = (List)ErisAlchemy.GSON.fromJson((Reader)reader, (TypeToken)new TypeToken<List<BannedRecipe>>(){});
            recipes.addAll(json);
        }
    }

    private static void loadEmcValues(Map<class_2960, OptionalDouble> map, class_2960 id, InputStream is) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is);){
            Map json = (Map)ErisAlchemy.GSON.fromJson((Reader)reader, (TypeToken)new TypeToken<Map<class_2960, Double>>(){});
            json.forEach((item, newEmcRaw) -> {
                OptionalDouble newEmc = newEmcRaw == null ? OptionalDouble.empty() : OptionalDouble.of(newEmcRaw);
                OptionalDouble oldEmc = (OptionalDouble)map.get(item);
                if (oldEmc != null && !newEmc.equals(oldEmc)) {
                    String oldStr = oldEmc.isEmpty() ? "NONE" : Double.toString(oldEmc.getAsDouble());
                    String newStr = newEmc.isEmpty() ? "NONE" : Double.toString(newEmc.getAsDouble());
                    ErisAlchemy.LOGGER.warn("Redefining the EMC value for {} from {} to {}", new Object[]{item, oldStr, newStr});
                }
                map.put((class_2960)item, newEmc);
            });
        }
    }

    private static void loadFakeRecipes(List<SimplifiedRecipe> recipes, class_2960 id, InputStream is) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is);){
            List json = (List)ErisAlchemy.GSON.fromJson((Reader)reader, (TypeToken)new TypeToken<List<SimplifiedRecipe>>(){});
            recipes.addAll(json);
        }
    }

    private EmcLoader() {
    }

    @FunctionalInterface
    private static interface Loader<T> {
        public void loadFile(T var1, class_2960 var2, InputStream var3) throws IOException;
    }
}

