/*
 * Decompiled with CFR 0.152.
 */
package lv.enes.mc.eris_alchemy.block.entity;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.stream.IntStream;
import lv.enes.mc.eris_alchemy.Emc;
import lv.enes.mc.eris_alchemy.ErisAlchemyRegistry;
import lv.enes.mc.eris_alchemy.block.entity.ChestLikeEntity;
import lv.enes.mc.eris_alchemy.block.entity.EmcStorageEntity;
import lv.enes.mc.eris_alchemy.client.ErisAlchemyClientRegistry;
import lv.enes.mc.eris_alchemy.menu.ChestLikeMenu;
import lv.enes.mc.eris_alchemy.menu.EnergyCondenserMenu;
import lv.enes.mc.eris_alchemy.utils.ContainerOpenersCounterUtil;
import lv.enes.mc.eris_alchemy.utils.SyncedValue;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_4730;
import org.quiltmc.loader.api.minecraft.ClientOnly;

public class EnergyCondenserEntity
extends ChestLikeEntity
implements EmcStorageEntity,
ExtendedScreenHandlerFactory {
    private static final int WIDTH = 13;
    private static final int HEIGHT = 7;
    private final class_2371<class_1799> items = class_2371.method_10213((int)92, (Object)class_1799.field_8037);
    public final SyncedValue.SyncedDouble storedEmc = new SyncedValue.SyncedDouble(0.0);

    public EnergyCondenserEntity(class_2338 pos, class_2680 state) {
        super(ErisAlchemyRegistry.BlockEntities.ENERGY_CONDENSER, pos, state);
    }

    @Nonnull
    protected ChestLikeMenu createMenu(int syncId, class_1661 playerInventory) {
        return new EnergyCondenserMenu(syncId, playerInventory, this);
    }

    @Override
    @Nonnull
    protected class_2371<class_1799> getItems() {
        return this.items;
    }

    @Override
    public double getMaxEmc() {
        return Emc.get((class_1799)this.items.get(0)).orElse(Double.POSITIVE_INFINITY);
    }

    @Override
    @Nonnull
    @ClientOnly
    public class_4730 getMaterial() {
        return ErisAlchemyClientRegistry.Materials.ENERGY_CONDENSER;
    }

    @Override
    @Nonnull
    protected class_2248 getParent() {
        return ErisAlchemyRegistry.Blocks.ENERGY_CONDENSER;
    }

    @Override
    public double getStoredEmc() {
        return (Double)this.storedEmc.getValue();
    }

    public SyncedValue.SyncedDouble getStoredEmcSyncer() {
        return this.storedEmc;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storedEmc.setValue(nbt.method_10574("stored_emc"));
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10549("stored_emc", ((Double)this.storedEmc.getValue()).doubleValue());
    }

    public void setStoredEmc(double storedEmc) {
        this.storedEmc.setValue(storedEmc);
        this.method_5431();
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        super.tick(world, pos, state);
        if (world.field_9236) {
            return;
        }
        double cost = this.getMaxEmc();
        this.tryConsumeEmc(cost);
        this.tryCloneTemplate(cost);
        this.storedEmc.syncIfChanged(ContainerOpenersCounterUtil.getOpeners(this.openersCounter));
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        this.storedEmc.serialize(buf);
    }

    private void tryCloneTemplate(double cost) {
        if (cost > this.getStoredEmc()) {
            return;
        }
        class_1799 template = (class_1799)this.items.get(0);
        this.items.stream().skip(1L).filter(stack -> class_1799.method_31577((class_1799)template, (class_1799)stack)).filter(stack -> stack.method_7947() < this.method_5444() && stack.method_7947() < stack.method_7914()).findFirst().ifPresentOrElse(stack -> {
            stack.method_7939(stack.method_7947() + 1);
            this.setStoredEmc(this.getStoredEmc() - cost);
            this.method_5431();
        }, () -> IntStream.range(1, this.items.size()).filter(i -> ((class_1799)this.items.get(i)).method_7960()).findFirst().ifPresent(emptySlot -> {
            this.items.set(emptySlot, (Object)template.method_46651(1));
            this.setStoredEmc(this.getStoredEmc() - cost);
            this.method_5431();
        }));
    }

    private void tryConsumeEmc(double cost) {
        if (cost <= this.getStoredEmc()) {
            return;
        }
        class_1799 template = (class_1799)this.items.get(0);
        Optional sacrifice = this.items.stream().skip(1L).filter(stack -> !class_1799.method_31577((class_1799)template, (class_1799)stack)).flatMap(stack -> Emc.get(stack).stream().mapToObj(emcValue -> new StackEmcPair((class_1799)stack, emcValue))).findFirst();
        sacrifice.ifPresent(pair -> {
            pair.stack.method_7939(pair.stack.method_7947() - 1);
            this.setStoredEmc(this.getStoredEmc() + pair.emc());
        });
    }

    private record StackEmcPair(class_1799 stack, double emc) {
    }
}

