/*
 * Decompiled with CFR 0.152.
 */
package lv.enes.mc.eris_alchemy.recipe;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import lv.enes.mc.eris_alchemy.utils.IngredientProvider;
import net.minecraft.class_1856;

public record BannedRecipe(Supplier<class_1856> input, Supplier<class_1856> output) {
    public static BannedRecipe deserialize(JsonElement el) {
        if (el.isJsonPrimitive() && el.getAsJsonPrimitive().isString()) {
            return BannedRecipe.deserialize(el.getAsString());
        }
        throw new JsonParseException("Banned recipes should all be strings");
    }

    public static BannedRecipe deserialize(String str) {
        int split = str.indexOf("->");
        Supplier<class_1856> input = IngredientProvider.deserialize(str.substring(0, split).trim());
        Supplier<class_1856> output = IngredientProvider.deserialize(str.substring(split + 2).trim());
        return new BannedRecipe(input, output);
    }

    public static class Deserializer
    implements JsonDeserializer<BannedRecipe> {
        public BannedRecipe deserialize(JsonElement el, Type t, JsonDeserializationContext ctx) throws JsonParseException {
            return BannedRecipe.deserialize(el);
        }
    }
}

