/*
 * Decompiled with CFR 0.152.
 */
package lv.enes.mc.eris_alchemy.recipe;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import earth.terrarium.chipped.common.recipes.ChippedRecipe;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lv.enes.mc.eris_alchemy.recipe.BannedRecipe;
import lv.enes.mc.eris_alchemy.utils.ForeignUtils;
import lv.enes.mc.eris_alchemy.utils.IngredientProvider;
import lv.enes.mc.eris_alchemy.utils.ItemUtils;
import lv.enes.mc.eris_alchemy.utils.RecipeUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public record SimplifiedRecipe(class_1799 output, List<class_1799> remainder, List<Supplier<class_1856>> input, boolean fromChipped) {
    public static List<SimplifiedRecipe> of(class_1860<?> recipe, class_5455 registryAccess) {
        if (ForeignUtils.isClassAvailable("earth.terrarium.chipped.common.recipes.ChippedRecipe") && recipe instanceof ChippedRecipe) {
            ChippedRecipe chippedRecipe = (ChippedRecipe)recipe;
            List remainder = List.of();
            return chippedRecipe.tags().stream().flatMap(tag -> {
                List<class_1792> items = tag.method_40239().map(class_6880::comp_349).toList();
                Predicate<class_1792> isOutput = item -> ItemUtils.getId((class_1935)item).method_12836().equals("chipped");
                List<List> inputs = items.stream().filter(item -> !isOutput.test((class_1792)item)).map(xva$0 -> class_1856.method_8091((class_1935[])new class_1935[]{xva$0})).map(x -> () -> x).map(List::of).toList();
                List<class_1799> outputs = items.stream().filter(isOutput).map(class_1792::method_7854).toList();
                return outputs.stream().flatMap(output -> inputs.stream().map(input -> new SimplifiedRecipe((class_1799)output, remainder, (List<Supplier<class_1856>>)input, true)));
            }).toList();
        }
        return List.of(new SimplifiedRecipe(RecipeUtils.getOutput(recipe, registryAccess), List.of(), RecipeUtils.getIngredients(recipe).stream().filter(ingredient -> !ingredient.method_8103()).map(x -> () -> x).toList(), false));
    }

    public Stream<class_2960> dependencies() {
        return Stream.concat(this.input.stream().map(Supplier::get).map(class_1856::method_8105).flatMap(Arrays::stream), this.remainder.stream()).map(ItemUtils::getId);
    }

    public boolean hasDuplication() {
        return this.remainder.stream().anyMatch(stack -> class_1799.method_7984((class_1799)stack, (class_1799)this.output)) || this.input.stream().anyMatch(ingredient -> ((class_1856)ingredient.get()).method_8093(this.output));
    }

    public boolean isAllowed(BannedRecipe ban) {
        if (!ban.output().get().method_8093(this.output())) {
            return true;
        }
        return this.dependencies().noneMatch(dep -> ban.input().get().method_8093(ItemUtils.get(dep).method_7854()));
    }

    public boolean isAllowed(Collection<BannedRecipe> bans) {
        return bans.stream().allMatch(this::isAllowed);
    }

    public static class Deserializer
    implements JsonDeserializer<SimplifiedRecipe> {
        @Nonnull
        public SimplifiedRecipe deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (!jsonElement.isJsonObject()) {
                throw new JsonParseException("Recipe must be an object");
            }
            JsonObject obj = jsonElement.getAsJsonObject();
            if (obj.get("output") == null || obj.get("input") == null) {
                throw new JsonParseException("Recipe must have 'output' and 'input' fields");
            }
            class_1799 output = this.parseOutputOrRemainder(obj.get("output")).orElseGet(() -> ((class_1792)class_1802.field_8162).method_7854());
            List remainder = this.parseRemainders(obj.get("remainder")).orElseGet(() -> List.of(class_1802.field_8162.method_7854()));
            List<Supplier<class_1856>> input = this.parseInputs(obj.get("input"));
            return new SimplifiedRecipe(output, remainder, input, false);
        }

        private List<Supplier<class_1856>> parseInputs(JsonElement el) {
            if (el.isJsonArray()) {
                return el.getAsJsonArray().asList().stream().map(IngredientProvider::deserialize).toList();
            }
            return List.of(IngredientProvider.deserialize(el));
        }

        private Optional<class_1799> parseOutputOrRemainder(JsonElement el) {
            if (el.isJsonObject()) {
                return ItemUtils.itemStackFromJson(el.getAsJsonObject());
            }
            if (el.isJsonPrimitive() && el.getAsJsonPrimitive().isString()) {
                class_2960 id = new class_2960(el.getAsString());
                return Optional.of(((class_1792)class_7923.field_41178.method_10223(id)).method_7854());
            }
            throw new JsonParseException("Recipe's output or remainder must be an object or a string");
        }

        private Optional<List<class_1799>> parseRemainders(JsonElement el) {
            if (el == null) {
                return Optional.of(List.of());
            }
            if (el.isJsonArray()) {
                List<Optional> optList = el.getAsJsonArray().asList().stream().map(this::parseOutputOrRemainder).toList();
                ArrayList<class_1799> retList = new ArrayList<class_1799>();
                for (Optional opt : optList) {
                    if (opt.isPresent()) {
                        retList.add((class_1799)opt.get());
                        continue;
                    }
                    return Optional.empty();
                }
                return Optional.of(retList);
            }
            return this.parseOutputOrRemainder(el).map(List::of);
        }
    }
}

