/*
 * Decompiled with CFR 0.152.
 */
package lv.enes.mc.eris_alchemy.utils;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ConsList<E> {
    public static <E> ConsList<E> cons(E car, ConsList<E> cdr) {
        return new Cons<E>(car, cdr);
    }

    public static <E> ConsList<E> nil() {
        return Nil.of();
    }

    @Nonnull
    public abstract Optional<E> car();

    @Nonnull
    public abstract ConsList<E> cdr();

    public boolean contains(E elem) {
        return this.stream().anyMatch(x -> Objects.equals(x, elem));
    }

    public Stream<E> stream() {
        Optional car = this.car();
        if (car.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(() -> Stream.of(car.get()), () -> this.cdr().stream()).flatMap(Supplier::get);
    }

    public String toString() {
        if (this.car().isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.car().get());
        this.stream().skip(1L).forEach(x -> {
            sb.append(" -> ");
            sb.append(x);
        });
        sb.append("]");
        return sb.toString();
    }

    private static final class Cons<E>
    extends ConsList<E> {
        private final E car;
        private final ConsList<E> cdr;

        public Cons(E car, ConsList<E> cdr) {
            this.car = car;
            this.cdr = cdr;
        }

        @Override
        @Nonnull
        public Optional<E> car() {
            return Optional.of(this.car);
        }

        @Override
        @Nonnull
        public ConsList<E> cdr() {
            return this.cdr;
        }
    }

    private static final class Nil<E>
    extends ConsList<E> {
        private static final Nil<?> INSTANCE = new Nil();

        public static <E> Nil<E> of() {
            return INSTANCE;
        }

        private Nil() {
        }

        @Override
        @Nonnull
        public Optional<E> car() {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public ConsList<E> cdr() {
            return Nil.of();
        }
    }
}

