/*
 * Decompiled with CFR 0.152.
 */
package lv.enes.mc.eris_alchemy.utils;

import jakarta.annotation.Nonnull;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lv.enes.mc.eris_alchemy.ErisAlchemyRegistry;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.quiltmc.loader.api.minecraft.MinecraftQuiltLoader;
import org.quiltmc.qsl.networking.api.PacketByteBufs;
import org.quiltmc.qsl.networking.api.ServerPlayNetworking;
import org.quiltmc.qsl.networking.api.client.ClientPlayNetworking;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class SyncedValue<E> {
    private static final Map<Long, WeakReference<SyncedValue<?>>> values = new HashMap();
    private final long id;
    private boolean changed = true;
    private E value;
    private static long nextId = 0L;

    public SyncedValue(E value) {
        this(SyncedValue.genId(), value);
    }

    public SyncedValue(long id, E value) {
        this.id = id;
        this.value = value;
        values.put(this.id, new WeakReference<SyncedValue>(this));
    }

    @Nonnull
    protected abstract E read(class_2540 var1);

    protected abstract void write(class_2540 var1, @Nonnull E var2);

    public void serialize(class_2540 buf) {
        buf.writeLongLE(this.id);
        this.write(buf, this.value);
    }

    public void setValue(E value) {
        this.value = value;
        this.changed = true;
    }

    public void syncIfChanged(Collection<class_3222> players) {
        if (!this.changed) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        this.serialize(buf);
        ServerPlayNetworking.send(players, (class_2960)ErisAlchemyRegistry.NetworkingConstants.UPDATE_SYNCED_VALUE, (class_2540)buf);
        this.changed = false;
    }

    private void readData(class_2540 buf) {
        this.changed = false;
        this.value = this.read(buf);
    }

    private static long genId() {
        return nextId++;
    }

    @Generated
    public E getValue() {
        return this.value;
    }

    static {
        if (MinecraftQuiltLoader.getEnvironmentType() == EnvType.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)ErisAlchemyRegistry.NetworkingConstants.UPDATE_SYNCED_VALUE, (client, handler, buf, responseSender) -> {
                SyncedValue holder;
                long id = buf.readLongLE();
                WeakReference<SyncedValue<?>> ref = values.get(id);
                SyncedValue syncedValue = holder = ref == null ? null : (SyncedValue)ref.get();
                if (holder != null) {
                    holder.readData(buf);
                }
            });
        }
    }

    public static final class SyncedDouble
    extends SyncedValue<Double> {
        public SyncedDouble(double value) {
            super(value);
        }

        public SyncedDouble(long id, double value) {
            super(id, value);
        }

        public static SyncedDouble deserialize(class_2540 buf) {
            long id = buf.readLongLE();
            double value = buf.readDoubleLE();
            return new SyncedDouble(id, value);
        }

        @Override
        @Nonnull
        protected Double read(class_2540 buf) {
            return buf.readDoubleLE();
        }

        @Override
        protected void write(class_2540 buf, @Nonnull Double value) {
            buf.writeDoubleLE(value.doubleValue());
        }
    }
}

