/*
 * Decompiled with CFR 0.152.
 */
package de.leximon.fluidlogged.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.leximon.fluidlogged.commands.arguments.FluidInput;
import de.leximon.fluidlogged.commands.arguments.FluidStateParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_3611;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class FluidStateArgument
implements ArgumentType<FluidInput> {
    private static final Collection<String> EXAMPLES = Arrays.asList("water", "minecraft:water", "water[foo=bar]");
    private final class_7225<class_3611> fluids;

    public FluidStateArgument(class_7157 commandBuildContext) {
        this.fluids = commandBuildContext.method_41699(class_7924.field_41270);
    }

    public static FluidStateArgument fluid(class_7157 commandBuildContext) {
        return new FluidStateArgument(commandBuildContext);
    }

    public FluidInput parse(StringReader stringReader) throws CommandSyntaxException {
        FluidStateParser.FluidResult result = FluidStateParser.parseForFluid(this.fluids, stringReader);
        return new FluidInput(result.fluidState(), result.properties().keySet());
    }

    public static FluidInput getFluid(CommandContext<class_2168> commandContext, String string) {
        return (FluidInput)commandContext.getArgument(string, FluidInput.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        return FluidStateParser.fillSuggestions(this.fluids, suggestionsBuilder, false);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

