/*
 * Decompiled with CFR 0.152.
 */
package de.leximon.fluidlogged.commands.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class FluidStateParser {
    public static final SimpleCommandExceptionType ERROR_NO_TAGS_ALLOWED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.block.tag.disallowed"));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_BLOCK = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"argument.block.id.invalid", (Object[])new Object[]{object}));
    public static final Dynamic2CommandExceptionType ERROR_UNKNOWN_PROPERTY = new Dynamic2CommandExceptionType((object, object2) -> class_2561.method_43469((String)"argument.block.property.unknown", (Object[])new Object[]{object, object2}));
    public static final Dynamic2CommandExceptionType ERROR_DUPLICATE_PROPERTY = new Dynamic2CommandExceptionType((object, object2) -> class_2561.method_43469((String)"argument.block.property.duplicate", (Object[])new Object[]{object2, object}));
    public static final Dynamic3CommandExceptionType ERROR_INVALID_VALUE = new Dynamic3CommandExceptionType((object, object2, object3) -> class_2561.method_43469((String)"argument.block.property.invalid", (Object[])new Object[]{object, object3, object2}));
    public static final Dynamic2CommandExceptionType ERROR_EXPECTED_VALUE = new Dynamic2CommandExceptionType((object, object2) -> class_2561.method_43469((String)"argument.block.property.novalue", (Object[])new Object[]{object, object2}));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_END_OF_PROPERTIES = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.block.property.unclosed"));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_TAG = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"arguments.block.tag.unknown", (Object[])new Object[]{object}));
    private static final char SYNTAX_START_PROPERTIES = '[';
    private static final char SYNTAX_START_NBT = '{';
    private static final char SYNTAX_END_PROPERTIES = ']';
    private static final char SYNTAX_EQUALS = '=';
    private static final char SYNTAX_PROPERTY_SEPARATOR = ',';
    private static final char SYNTAX_TAG = '#';
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> SUGGEST_NOTHING = SuggestionsBuilder::buildFuture;
    private final class_7225<class_3611> fluids;
    private final StringReader reader;
    private final boolean forTesting;
    private final Map<class_2769<?>, Comparable<?>> properties = Maps.newHashMap();
    private final Map<String, String> vagueProperties = Maps.newHashMap();
    private class_2960 id = new class_2960("");
    @Nullable
    private class_2689<class_3611, class_3610> definition;
    @Nullable
    private class_3610 state;
    @Nullable
    private class_6885<class_3611> tag;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;

    private FluidStateParser(class_7225<class_3611> holderLookup, StringReader stringReader, boolean forTesting) {
        this.fluids = holderLookup;
        this.reader = stringReader;
        this.forTesting = forTesting;
    }

    public static FluidResult parseForFluid(class_7225<class_3611> holderLookup, StringReader stringReader) throws CommandSyntaxException {
        int i = stringReader.getCursor();
        try {
            FluidStateParser parser = new FluidStateParser(holderLookup, stringReader, false);
            parser.parse();
            return new FluidResult(parser.state, parser.properties);
        }
        catch (CommandSyntaxException var5) {
            stringReader.setCursor(i);
            throw var5;
        }
    }

    public static CompletableFuture<Suggestions> fillSuggestions(class_7225<class_3611> holderLookup, SuggestionsBuilder suggestionsBuilder, boolean forTesting) {
        StringReader stringReader = new StringReader(suggestionsBuilder.getInput());
        stringReader.setCursor(suggestionsBuilder.getStart());
        FluidStateParser FluidStateParser2 = new FluidStateParser(holderLookup, stringReader, forTesting);
        try {
            FluidStateParser2.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return FluidStateParser2.suggestions.apply(suggestionsBuilder.createOffset(stringReader.getCursor()));
    }

    private void parse() throws CommandSyntaxException {
        this.suggestions = this.forTesting ? this::suggestFluidIdOrTag : this::suggestItem;
        if (this.reader.canRead() && this.reader.peek() == '#') {
            this.readTag();
            this.suggestions = this::suggestOpenVagueProperties;
            if (this.reader.canRead() && this.reader.peek() == '[') {
                this.readVagueProperties();
            }
        } else {
            this.readFluid();
            this.suggestions = this::suggestOpenProperties;
            if (this.reader.canRead() && this.reader.peek() == '[') {
                this.readProperties();
            }
        }
    }

    private CompletableFuture<Suggestions> suggestPropertyNameOrEnd(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf(']'));
        }
        return this.suggestPropertyName(suggestionsBuilder);
    }

    private CompletableFuture<Suggestions> suggestVaguePropertyNameOrEnd(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf(']'));
        }
        return this.suggestVaguePropertyName(suggestionsBuilder);
    }

    private CompletableFuture<Suggestions> suggestPropertyName(SuggestionsBuilder suggestionsBuilder) {
        String string = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (class_2769 property : this.state.method_28501()) {
            if (this.properties.containsKey(property) || !property.method_11899().startsWith(string)) continue;
            suggestionsBuilder.suggest(property.method_11899() + "=");
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestVaguePropertyName(SuggestionsBuilder suggestionsBuilder) {
        String string = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        if (this.tag != null) {
            for (class_6880 holder : this.tag) {
                for (class_2769 property : ((class_3611)holder.comp_349()).method_15783().method_11659()) {
                    if (this.vagueProperties.containsKey(property.method_11899()) || !property.method_11899().startsWith(string)) continue;
                    suggestionsBuilder.suggest(property.method_11899() + "=");
                }
            }
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestEquals(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf('='));
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestNextPropertyOrEnd(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf(']'));
        }
        if (suggestionsBuilder.getRemaining().isEmpty() && this.properties.size() < this.state.method_28501().size()) {
            suggestionsBuilder.suggest(String.valueOf(','));
        }
        return suggestionsBuilder.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder addSuggestions(SuggestionsBuilder suggestionsBuilder, class_2769<T> property) {
        for (Comparable t : property.method_11898()) {
            if (t instanceof Integer) {
                Integer i = (Integer)t;
                suggestionsBuilder.suggest(i.intValue());
                continue;
            }
            suggestionsBuilder.suggest(property.method_11901(t));
        }
        return suggestionsBuilder;
    }

    private CompletableFuture<Suggestions> suggestVaguePropertyValue(SuggestionsBuilder builder, String name) {
        boolean bl = false;
        if (this.tag != null) {
            block0: for (class_6880 registryEntry : this.tag) {
                class_3611 fluid = (class_3611)registryEntry.comp_349();
                class_2769 property = fluid.method_15783().method_11663(name);
                if (property != null) {
                    FluidStateParser.addSuggestions(builder, property);
                }
                if (bl) continue;
                for (class_2769 property2 : fluid.method_15783().method_11659()) {
                    if (this.vagueProperties.containsKey(property2.method_11899())) continue;
                    bl = true;
                    continue block0;
                }
            }
        }
        if (bl) {
            builder.suggest(String.valueOf(','));
        }
        builder.suggest(String.valueOf(']'));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOpenVagueProperties(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty() && this.tag != null) {
            boolean hasProps = false;
            for (class_6880 holder : this.tag) {
                class_3611 block = (class_3611)holder.comp_349();
                hasProps |= !block.method_15783().method_11659().isEmpty();
            }
            if (hasProps) {
                suggestionsBuilder.suggest(String.valueOf('['));
            }
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOpenProperties(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty() && !this.definition.method_11659().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf('['));
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestTag(SuggestionsBuilder suggestionsBuilder) {
        return class_2172.method_40182(this.fluids.method_46755().map(class_6862::comp_327), (SuggestionsBuilder)suggestionsBuilder, (String)String.valueOf('#'));
    }

    private CompletableFuture<Suggestions> suggestItem(SuggestionsBuilder suggestionsBuilder) {
        return class_2172.method_9257(this.fluids.method_46754().map(class_5321::method_29177), (SuggestionsBuilder)suggestionsBuilder);
    }

    private CompletableFuture<Suggestions> suggestFluidIdOrTag(SuggestionsBuilder suggestionsBuilder) {
        this.suggestTag(suggestionsBuilder);
        this.suggestItem(suggestionsBuilder);
        return suggestionsBuilder.buildFuture();
    }

    private void readFluid() throws CommandSyntaxException {
        int i = this.reader.getCursor();
        this.id = class_2960.method_12835((StringReader)this.reader);
        class_3611 block = (class_3611)((class_6880.class_6883)this.fluids.method_46746(class_5321.method_29179((class_5321)class_7924.field_41270, (class_2960)this.id)).orElseThrow(() -> {
            this.reader.setCursor(i);
            return ERROR_UNKNOWN_BLOCK.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString());
        })).comp_349();
        this.definition = block.method_15783();
        this.state = block.method_15785();
    }

    private void readTag() throws CommandSyntaxException {
        if (!this.forTesting) {
            throw ERROR_NO_TAGS_ALLOWED.createWithContext((ImmutableStringReader)this.reader);
        }
        int i = this.reader.getCursor();
        this.reader.expect('#');
        this.suggestions = this::suggestTag;
        class_2960 resourceLocation = class_2960.method_12835((StringReader)this.reader);
        this.tag = (class_6885)this.fluids.method_46733(class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)resourceLocation)).orElseThrow(() -> {
            this.reader.setCursor(i);
            return ERROR_UNKNOWN_TAG.createWithContext((ImmutableStringReader)this.reader, (Object)resourceLocation.toString());
        });
    }

    private void readProperties() throws CommandSyntaxException {
        this.reader.skip();
        this.suggestions = this::suggestPropertyNameOrEnd;
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != ']') {
            this.reader.skipWhitespace();
            int i = this.reader.getCursor();
            String string = this.reader.readString();
            class_2769 property = this.definition.method_11663(string);
            if (property == null) {
                this.reader.setCursor(i);
                throw ERROR_UNKNOWN_PROPERTY.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)string);
            }
            if (this.properties.containsKey(property)) {
                this.reader.setCursor(i);
                throw ERROR_DUPLICATE_PROPERTY.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)string);
            }
            this.reader.skipWhitespace();
            this.suggestions = this::suggestEquals;
            if (this.reader.canRead() && this.reader.peek() == '=') {
                this.reader.skip();
                this.reader.skipWhitespace();
                this.suggestions = suggestionsBuilder -> FluidStateParser.addSuggestions(suggestionsBuilder, property).buildFuture();
                int j = this.reader.getCursor();
                this.setValue(property, this.reader.readString(), j);
                this.suggestions = this::suggestNextPropertyOrEnd;
                this.reader.skipWhitespace();
                if (!this.reader.canRead()) continue;
                if (this.reader.peek() == ',') {
                    this.reader.skip();
                    this.suggestions = this::suggestPropertyName;
                    continue;
                }
                if (this.reader.peek() == ']') break;
                throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
            }
            throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)string);
        }
        if (!this.reader.canRead()) {
            throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
        }
        this.reader.skip();
    }

    private void readVagueProperties() throws CommandSyntaxException {
        this.reader.skip();
        this.suggestions = this::suggestVaguePropertyNameOrEnd;
        int i = -1;
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != ']') {
            this.reader.skipWhitespace();
            int j = this.reader.getCursor();
            String string = this.reader.readString();
            if (this.vagueProperties.containsKey(string)) {
                this.reader.setCursor(j);
                throw ERROR_DUPLICATE_PROPERTY.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)string);
            }
            this.reader.skipWhitespace();
            if (!this.reader.canRead() || this.reader.peek() != '=') {
                this.reader.setCursor(j);
                throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)string);
            }
            this.reader.skip();
            this.reader.skipWhitespace();
            this.suggestions = suggestionsBuilder -> this.suggestVaguePropertyValue((SuggestionsBuilder)suggestionsBuilder, string);
            i = this.reader.getCursor();
            String string2 = this.reader.readString();
            this.vagueProperties.put(string, string2);
            this.reader.skipWhitespace();
            if (!this.reader.canRead()) continue;
            i = -1;
            if (this.reader.peek() == ',') {
                this.reader.skip();
                this.suggestions = this::suggestVaguePropertyName;
                continue;
            }
            if (this.reader.peek() == ']') break;
            throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
        }
        if (this.reader.canRead()) {
            this.reader.skip();
            return;
        }
        if (i >= 0) {
            this.reader.setCursor(i);
        }
        throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
    }

    private <T extends Comparable<T>> void setValue(class_2769<T> property, String string, int i) throws CommandSyntaxException {
        Optional optional = property.method_11900(string);
        if (!optional.isPresent()) {
            this.reader.setCursor(i);
            throw ERROR_INVALID_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)property.method_11899(), (Object)string);
        }
        this.state = (class_3610)this.state.method_11657(property, (Comparable)optional.get());
        this.properties.put(property, (Comparable)optional.get());
    }

    public static String serialize(class_3610 blockState) {
        StringBuilder stringBuilder = new StringBuilder(blockState.method_40180().method_40230().map(resourceKey -> resourceKey.method_29177().toString()).orElse("empty"));
        if (!blockState.method_28501().isEmpty()) {
            stringBuilder.append('[');
            boolean bl = false;
            for (Map.Entry entry : blockState.method_11656().entrySet()) {
                if (bl) {
                    stringBuilder.append(',');
                }
                FluidStateParser.appendProperty(stringBuilder, (class_2769)entry.getKey(), (Comparable)entry.getValue());
                bl = true;
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    private static <T extends Comparable<T>> void appendProperty(StringBuilder stringBuilder, class_2769<T> property, Comparable<?> comparable) {
        stringBuilder.append(property.method_11899());
        stringBuilder.append('=');
        stringBuilder.append(property.method_11901(comparable));
    }

    public record FluidResult(class_3610 fluidState, Map<class_2769<?>, Comparable<?>> properties) {
    }

    public record TagResult(class_6885<class_3611> tag, Map<String, String> vagueProperties) {
    }
}

