/*
 * Decompiled with CFR 0.152.
 */
package de.leximon.fluidlogged.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import de.leximon.fluidlogged.config.Config;
import de.leximon.fluidlogged.config.controller.BlockPredicateController;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class BlockPredicateList {
    private final Supplier<List<String>> defaultBlocks;
    private final boolean justForFunBlacklist;
    private final class_2561 categoryName;
    private final List<class_2561> description;
    private List<String> blocks;
    private boolean blacklist = false;
    private final HashSet<class_2248> compiledBlocks = new HashSet();

    public BlockPredicateList(Supplier<List<String>> defaultBlocks, boolean justForFunBlacklist, class_2561 categoryName, List<class_2561> description) {
        this.defaultBlocks = defaultBlocks;
        this.justForFunBlacklist = justForFunBlacklist;
        this.categoryName = categoryName;
        this.description = description;
        this.setBlocks(defaultBlocks.get());
    }

    public void setBlocks(List<String> blocks) {
        this.blocks = blocks;
        this.compile();
    }

    public List<String> getBlocks() {
        return this.blocks;
    }

    public void compile() {
        this.compiledBlocks.clear();
        for (String id : this.blocks) {
            if (!id.startsWith("#")) {
                this.compileSingleBlock(id);
                continue;
            }
            this.compileBlockTag(id.substring(1));
        }
    }

    private void compileSingleBlock(String id) {
        class_2960 location = class_2960.method_12829((String)id);
        if (location == null) {
            return;
        }
        Optional blockOpt = class_7923.field_41175.method_17966(location);
        if (blockOpt.isEmpty()) {
            return;
        }
        this.compiledBlocks.add((class_2248)blockOpt.get());
    }

    private void compileBlockTag(String id) {
        class_2960 location = class_2960.method_12829((String)id);
        if (location == null) {
            return;
        }
        class_6862 blockTag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)location);
        Iterable blockHolders = class_7923.field_41175.method_40286(blockTag);
        for (class_6880 blockHolder : blockHolders) {
            this.compiledBlocks.add((class_2248)blockHolder.comp_349());
        }
    }

    public boolean contains(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        if (block instanceof class_2404 || blockState.method_26215()) {
            return false;
        }
        return this.compiledBlocks.contains(block) ^ this.blacklist;
    }

    public ConfigCategory createCategory() {
        return ConfigCategory.createBuilder().name(this.categoryName).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)(this.justForFunBlacklist ? "fluidlogged.config.blacklist_just_for_fun" : "fluidlogged.config.blacklist"))).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"fluidlogged.config.blacklist.desc")})).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true).yesNoFormatter()).binding((Object)false, () -> this.blacklist, value -> {
            this.blacklist = value;
        }).build()).group((OptionGroup)ListOption.createBuilder().name((class_2561)class_2561.method_43471((String)"fluidlogged.config.blocks")).description(OptionDescription.of((class_2561[])((class_2561[])this.description.toArray(class_2561[]::new)))).binding(this.defaultBlocks.get(), this::getBlocks, this::setBlocks).customController(BlockPredicateController::new).initial((Object)"").build()).build();
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("blacklist", Boolean.valueOf(this.blacklist));
        obj.add("blocks", Config.GSON.toJsonTree(this.blocks));
        return obj;
    }

    public void fromJson(JsonObject obj) {
        if (obj.has("blocks")) {
            JsonElement element = obj.get("blocks");
            List blocks = (List)Config.GSON.fromJson(element, (TypeToken)new TypeToken<List<String>>(){});
            this.setBlocks(blocks);
        }
        if (obj.has("blacklist")) {
            this.blacklist = obj.get("blacklist").getAsBoolean();
        }
    }
}

