/*
 * Decompiled with CFR 0.152.
 */
package de.leximon.fluidlogged.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.leximon.fluidlogged.Fluidlogged;
import de.leximon.fluidlogged.config.BlockPredicateList;
import de.leximon.fluidlogged.config.ConfigDefaults;
import de.leximon.fluidlogged.platform.services.Services;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_437;

public class Config {
    public static final String CONFIG_FILE_NAME = "fluidlogged.json";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final ConfigDefaults CONFIG_DEFAULTS = Services.PLATFORM.getConfigDefaults();
    private static final BlockPredicateList fluidloggableBlocks = new BlockPredicateList(CONFIG_DEFAULTS::fluidloggableBlocks, false, (class_2561)class_2561.method_43471((String)"fluidlogged.config.fluidloggable_blocks"), (List<class_2561>)ImmutableList.of((Object)class_2561.method_43471((String)"fluidlogged.config.fluidloggable_blocks.desc")));
    private static boolean fluidPermeabilityEnabled = true;
    private static final BlockPredicateList fluidPermeableBlocks = new BlockPredicateList(CONFIG_DEFAULTS::fluidPermeableBlocks, false, (class_2561)class_2561.method_43471((String)"fluidlogged.config.fluid_permeable_blocks"), (List<class_2561>)ImmutableList.of((Object)class_2561.method_43471((String)"fluidlogged.config.fluid_permeable_blocks.desc"), (Object)class_2561.method_43473(), (Object)class_2561.method_43471((String)"fluidlogged.config.fluid_permeable_blocks.desc.note").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})));
    private static final BlockPredicateList shapeIndependentFluidPermeableBlocks = new BlockPredicateList(CONFIG_DEFAULTS::shapeIndependentFluidPermeableBlocks, true, (class_2561)class_2561.method_43471((String)"fluidlogged.config.shape_independent_fluid_permeable_blocks"), (List<class_2561>)ImmutableList.of((Object)class_2561.method_43471((String)"fluidlogged.config.shape_independent_fluid_permeable_blocks.desc"), (Object)class_2561.method_43473(), (Object)class_2561.method_43471((String)"fluidlogged.config.shape_independent_fluid_permeable_blocks.desc.note").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})));

    public static boolean isFluidloggable(class_2680 block) {
        return fluidloggableBlocks.contains(block);
    }

    public static boolean isFluidPermeabilityEnabled() {
        return fluidPermeabilityEnabled;
    }

    public static boolean isFluidPermeable(class_2680 block) {
        return fluidPermeableBlocks.contains(block);
    }

    public static boolean isShapeIndependentFluidPermeable(class_2680 block) {
        return shapeIndependentFluidPermeableBlocks.contains(block);
    }

    public static void compile() {
        fluidloggableBlocks.compile();
        fluidPermeableBlocks.compile();
        shapeIndependentFluidPermeableBlocks.compile();
    }

    public static void save() {
        File file = Services.PLATFORM.getConfigFile();
        JsonObject obj = new JsonObject();
        obj.addProperty("fluid_permeability_enabled", Boolean.valueOf(fluidPermeabilityEnabled));
        obj.add("fluidloggable_blocks", (JsonElement)fluidloggableBlocks.toJson());
        obj.add("fluid_permeable_blocks", (JsonElement)fluidPermeableBlocks.toJson());
        obj.add("shape_independent_fluid_permeable_blocks", (JsonElement)shapeIndependentFluidPermeableBlocks.toJson());
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((JsonElement)obj, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config fluidlogged.json", e);
        }
    }

    public static void load() {
        File file = Services.PLATFORM.getConfigFile();
        if (!file.exists()) {
            Config.save();
            return;
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (obj.has("fluid_permeability_enabled")) {
                fluidPermeabilityEnabled = obj.get("fluid_permeability_enabled").getAsBoolean();
            }
            if (obj.has("fluidloggable_blocks") && obj.get("fluidloggable_blocks").isJsonObject()) {
                fluidloggableBlocks.fromJson(obj.getAsJsonObject("fluidloggable_blocks"));
            }
            if (obj.has("fluid_permeable_blocks")) {
                fluidPermeableBlocks.fromJson(obj.getAsJsonObject("fluid_permeable_blocks"));
            }
            if (obj.has("shape_independent_fluid_permeable_blocks")) {
                shapeIndependentFluidPermeableBlocks.fromJson(obj.getAsJsonObject("shape_independent_fluid_permeable_blocks"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config fluidlogged.json", e);
        }
    }

    public static class_437 createConfigScreen(class_437 parent) {
        return YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"fluidlogged.config")).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"fluidlogged.config.general")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"fluidlogged.config.general.enable_fluid_permeability")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"fluidlogged.config.general.enable_fluid_permeability.desc")}).image(Fluidlogged.id("textures/fluid_permeability_example.png"), 520, 293).build()).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true).yesNoFormatter()).binding((Object)true, () -> fluidPermeabilityEnabled, value -> {
            fluidPermeabilityEnabled = value;
        }).build()).build()).category(fluidloggableBlocks.createCategory()).category(fluidPermeableBlocks.createCategory()).category(shapeIndependentFluidPermeableBlocks.createCategory()).save(Config::save).build().generateScreen(parent);
    }
}

