/*
 * Decompiled with CFR 0.152.
 */
package de.leximon.fluidlogged.mixin;

import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class FluidloggedFabricMixinPlugin
implements IMixinConfigPlugin {
    private static final boolean SODIUM_LOADED = FluidloggedFabricMixinPlugin.isModLoaded("sodium");
    private static final boolean LITHIUM_LOADED = FluidloggedFabricMixinPlugin.isModLoaded("lithium");
    private static final boolean MILK_LIB_LOADED = FluidloggedFabricMixinPlugin.isModLoaded("milk");

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!SODIUM_LOADED && mixinClassName.startsWith("de.leximon.fluidlogged.mixin.classes.fabric.compat_sodium")) {
            return false;
        }
        if (!LITHIUM_LOADED && mixinClassName.startsWith("de.leximon.fluidlogged.mixin.classes.fabric.compat_lithium")) {
            return false;
        }
        return MILK_LIB_LOADED || !mixinClassName.startsWith("de.leximon.fluidlogged.mixin.classes.fabric.compat_milk_lib");
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static boolean isModLoaded(String name) {
        return FabricLoader.getInstance().isModLoaded(name);
    }
}

