/*
 * Decompiled with CFR 0.152.
 */
package de.leximon.fluidlogged.mixin.classes;

import de.leximon.fluidlogged.mixin.extensions.LevelChunkSectionExtension;
import de.leximon.fluidlogged.mixin.extensions.RenderChunkExtension;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_5539;
import net.minecraft.class_6849;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_6849.class})
public class RenderChunkMixin
implements RenderChunkExtension {
    @Shadow
    @Final
    private class_2818 field_36313;
    @Shadow
    @Final
    @Nullable
    private List<class_2841<class_2680>> field_36311;
    @Unique
    private List<Short2ObjectMap<class_3610>> fluidStatesSections;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void injectInit(class_2818 levelChunk, CallbackInfo ci) {
        if (levelChunk instanceof class_2812) {
            return;
        }
        class_2826[] levelChunkSections = levelChunk.method_12006();
        this.fluidStatesSections = new ArrayList<Short2ObjectMap<class_3610>>(levelChunkSections.length);
        for (class_2826 levelChunkSection : levelChunkSections) {
            this.fluidStatesSections.add((Short2ObjectMap<class_3610>)(levelChunkSection.method_38292() ? null : new Short2ObjectOpenHashMap(((LevelChunkSectionExtension)levelChunkSection).getFluidStates())));
        }
    }

    @Override
    public class_3610 getFluidState(class_2338 blockPos) {
        int x = blockPos.method_10263();
        int y = blockPos.method_10264();
        int z = blockPos.method_10260();
        if (this.field_36311 == null) {
            return class_3612.field_15906.method_15785();
        }
        try {
            int sectionIndex = this.field_36313.method_31602(y);
            if (sectionIndex < 0 || sectionIndex >= this.field_36311.size()) {
                return class_3612.field_15906.method_15785();
            }
            class_2841<class_2680> palettedContainer = this.field_36311.get(sectionIndex);
            if (palettedContainer == null) {
                return class_3612.field_15906.method_15785();
            }
            class_2680 blockState = (class_2680)palettedContainer.method_12321(x & 0xF, y & 0xF, z & 0xF);
            class_3610 defaultFluidState = blockState.method_26227();
            if (!defaultFluidState.method_15769()) {
                return defaultFluidState;
            }
            Short2ObjectMap<class_3610> fluidStates = this.fluidStatesSections.get(sectionIndex);
            if (fluidStates == null) {
                return defaultFluidState;
            }
            class_3610 fluidState = (class_3610)fluidStates.get((short)((x & 0xF) << 8 | (y & 0xF) << 4 | z & 0xF));
            if (fluidState == null) {
                return defaultFluidState;
            }
            return fluidState;
        }
        catch (Throwable var8) {
            class_128 crashReport = class_128.method_560((Throwable)var8, (String)"Getting block state");
            class_129 crashReportCategory = crashReport.method_562("Block being got");
            crashReportCategory.method_577("Location", () -> class_129.method_581((class_5539)this.field_36313, (int)x, (int)y, (int)z));
            throw new class_148(crashReport);
        }
    }
}

