/*
 * Decompiled with CFR 0.152.
 */
package de.leximon.fluidlogged.mixin.classes.storing_and_access;

import de.leximon.fluidlogged.mixin.extensions.LevelChunkSectionExtension;
import de.leximon.fluidlogged.platform.services.Services;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2826;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2826.class})
public class LevelChunkSectionMixin
implements LevelChunkSectionExtension {
    @Unique
    private Short2ObjectMap<class_3610> fluidStates;

    @Override
    public Short2ObjectMap<class_3610> createAndSetFluidStatesMap() {
        Short2ObjectOpenHashMap fluidStates = new Short2ObjectOpenHashMap();
        fluidStates.defaultReturnValue((Object)class_3612.field_15906.method_15785());
        this.fluidStates = fluidStates;
        return fluidStates;
    }

    @Override
    public Short2ObjectMap<class_3610> getFluidStates() {
        return this.fluidStates;
    }

    @Override
    public class_3610 setFluidState(int x, int y, int z, class_3610 fluidState) {
        if (fluidState.method_15769()) {
            return (class_3610)this.fluidStates.remove((short)(x << 8 | y << 4 | z));
        }
        return (class_3610)this.fluidStates.put((short)(x << 8 | y << 4 | z), (Object)fluidState);
    }

    @Override
    public class_3610 getFluidStateExact(int x, int y, int z) {
        return (class_3610)this.fluidStates.get((short)(x << 8 | y << 4 | z));
    }

    @Inject(method={"<init>(Lnet/minecraft/core/Registry;)V"}, at={@At(value="RETURN")})
    private void injectInit(class_2378<class_1959> registry, CallbackInfo ci) {
        this.createAndSetFluidStatesMap();
    }

    @Inject(method={"getFluidState"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectGetFluidState(int x, int y, int z, CallbackInfoReturnable<class_3610> cir) {
        class_3610 fluidState = (class_3610)cir.getReturnValue();
        if (!fluidState.method_15769()) {
            return;
        }
        fluidState = (class_3610)this.fluidStates.get((short)(x << 8 | y << 4 | z));
        if (fluidState == null) {
            return;
        }
        cir.setReturnValue((Object)fluidState);
    }

    @Inject(method={"hasOnlyAir"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectHasOnlyAir(CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        cir.setReturnValue((Object)this.fluidStates.isEmpty());
    }

    @Inject(method={"getSerializedSize"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectGetSerializedSize(CallbackInfoReturnable<Integer> cir) {
        int fluidStatesSize = 2 + this.fluidStates.size() * 6;
        cir.setReturnValue((Object)((Integer)cir.getReturnValue() + fluidStatesSize));
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    private void injectWrite(class_2540 buf, CallbackInfo ci) {
        buf.writeShort(this.fluidStates.size());
        for (Short2ObjectMap.Entry entry : this.fluidStates.short2ObjectEntrySet()) {
            buf.writeShort((int)entry.getShortKey());
            buf.writeInt(Services.PLATFORM.getFluidStateIdMapper().method_10206((Object)((class_3610)entry.getValue())));
        }
    }

    @Inject(method={"read"}, at={@At(value="TAIL")})
    private void injectRead(class_2540 buf, CallbackInfo ci) {
        this.fluidStates.clear();
        short size = buf.readShort();
        for (short i = 0; i < size; i = (short)(i + 1)) {
            short pos = buf.readShort();
            class_3610 fluidState = (class_3610)Services.PLATFORM.getFluidStateIdMapper().method_10200(buf.readInt());
            this.fluidStates.put(pos, (Object)fluidState);
        }
    }
}

