/*
 * Decompiled with CFR 0.152.
 */
package de.leximon.fluidlogged.platform;

import de.leximon.fluidlogged.config.ConfigDefaults;
import de.leximon.fluidlogged.config.FabricConfigDefaults;
import de.leximon.fluidlogged.network.fabric.ClientboundFluidUpdatePacket;
import de.leximon.fluidlogged.network.fabric.ClientboundSectionFluidsUpdatePacket;
import de.leximon.fluidlogged.platform.services.IPlatformHelper;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2338;
import net.minecraft.class_2361;
import net.minecraft.class_2826;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4076;

public class FabricPlatformHelper
implements IPlatformHelper {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("fluidlogged.json");
    private static final ConfigDefaults CONFIG_DEFAULTS = new FabricConfigDefaults();

    @Override
    public Path getConfigPath() {
        return CONFIG_PATH;
    }

    @Override
    public ConfigDefaults getConfigDefaults() {
        return CONFIG_DEFAULTS;
    }

    @Override
    public class_2361<class_3610> getFluidStateIdMapper() {
        return class_3611.field_15904;
    }

    @Override
    public void broadcastFluidUpdatePacket(List<class_3222> players, class_2338 pos, class_3610 state) {
        ClientboundFluidUpdatePacket packet = new ClientboundFluidUpdatePacket(pos, state);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
        }
    }

    @Override
    public void broadcastSectionFluidsUpdatePacket(List<class_3222> players, class_4076 sectionPos, ShortSet changedFluids, class_2826 levelChunkSection) {
        ClientboundSectionFluidsUpdatePacket packet = new ClientboundSectionFluidsUpdatePacket(sectionPos, changedFluids, levelChunkSection);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
        }
    }
}

