/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.compat.IrisCompat;
import net.raphimc.immediatelyfast.feature.core.BufferBuilderPool;

public class BatchableBufferSource
extends class_4597.class_4598
implements AutoCloseable {
    private static final class_287 FALLBACK_BUFFER = new class_287(0);
    protected final Reference2ObjectMap<class_1921, ReferenceSet<class_287>> fallbackBuffers = new Reference2ObjectLinkedOpenHashMap();
    protected final ReferenceSet<class_1921> activeLayers = new ReferenceLinkedOpenHashSet();
    protected boolean drawFallbackLayersFirst = false;

    public BatchableBufferSource() {
        this((Map<class_1921, class_287>)ImmutableMap.of());
    }

    public BatchableBufferSource(Map<class_1921, class_287> layerBuffers) {
        this(FALLBACK_BUFFER, layerBuffers);
    }

    public BatchableBufferSource(class_287 fallbackBuffer, Map<class_1921, class_287> layerBuffers) {
        super(fallbackBuffer, layerBuffers);
    }

    public class_4588 getBuffer(class_1921 layer) {
        Optional newLayer = layer.method_24296();
        if (!this.drawFallbackLayersFirst && !this.field_20954.equals(newLayer) && this.field_20954.isPresent() && !this.field_20953.containsKey(this.field_20954.get())) {
            this.drawFallbackLayersFirst = true;
        }
        this.field_20954 = newLayer;
        class_287 bufferBuilder = this.getOrCreateBufferBuilder(layer);
        if (bufferBuilder.method_22893() && !layer.method_43332()) {
            throw new IllegalStateException("Tried to write shared vertices into the same buffer");
        }
        if (!bufferBuilder.method_22893()) {
            if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
                IrisCompat.iris$beginWithoutExtending.accept(bufferBuilder, layer.method_23033(), layer.method_23031());
            } else {
                bufferBuilder.method_1328(layer.method_23033(), layer.method_23031());
            }
            this.activeLayers.add((Object)layer);
        } else if ((ImmediatelyFast.config.debug_only_use_last_usage_for_batch_ordering || layer.field_21363.contains("immediatelyfast:renderlast")) && this.activeLayers.contains((Object)layer)) {
            this.activeLayers.remove((Object)layer);
            this.activeLayers.add((Object)layer);
        }
        return bufferBuilder;
    }

    public void method_37104() {
        this.field_20954 = Optional.empty();
        this.drawFallbackLayersFirst = false;
        int sortedLayersLength = 0;
        class_1921[] sortedLayers = new class_1921[this.activeLayers.size()];
        for (class_1921 layer : this.activeLayers) {
            if (this.field_20953.containsKey(layer)) continue;
            sortedLayers[sortedLayersLength++] = layer;
        }
        if (sortedLayersLength == 0) {
            return;
        }
        Arrays.sort(sortedLayers, (l1, l2) -> Integer.compare(this.getLayerOrder((class_1921)l1), this.getLayerOrder((class_1921)l2)));
        for (int i = 0; i < sortedLayersLength; ++i) {
            this.method_22994(sortedLayers[i]);
        }
    }

    public void method_22993() {
        if (this.activeLayers.isEmpty()) {
            this.close();
            return;
        }
        this.method_37104();
        for (class_1921 layer : this.field_20953.keySet()) {
            this.method_22994(layer);
        }
    }

    public void method_22994(class_1921 layer) {
        if (this.drawFallbackLayersFirst) {
            this.method_37104();
        }
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(false);
        }
        this.activeLayers.remove((Object)layer);
        for (class_287 bufferBuilder : this.getBufferBuilder(layer)) {
            if (bufferBuilder == null) continue;
            layer.method_23012(bufferBuilder, RenderSystem.getVertexSorting());
        }
        this.fallbackBuffers.remove((Object)layer);
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(true);
        }
    }

    @Override
    public void close() {
        this.field_20954 = Optional.empty();
        this.drawFallbackLayersFirst = false;
        for (class_1921 layer : this.activeLayers) {
            for (class_287 bufferBuilder : this.getBufferBuilder(layer)) {
                bufferBuilder.method_1326().method_43585();
            }
        }
        this.activeLayers.clear();
        this.fallbackBuffers.clear();
    }

    public boolean hasActiveLayers() {
        return !this.activeLayers.isEmpty();
    }

    protected class_287 getOrCreateBufferBuilder(class_1921 layer) {
        if (!layer.method_43332()) {
            return this.addNewFallbackBuffer(layer);
        }
        if (this.field_20953.containsKey(layer)) {
            return (class_287)this.field_20953.get(layer);
        }
        if (this.fallbackBuffers.containsKey((Object)layer)) {
            return (class_287)((ReferenceSet)this.fallbackBuffers.get((Object)layer)).iterator().next();
        }
        return this.addNewFallbackBuffer(layer);
    }

    protected Set<class_287> getBufferBuilder(class_1921 layer) {
        if (this.fallbackBuffers.containsKey((Object)layer)) {
            return (Set)this.fallbackBuffers.get((Object)layer);
        }
        if (this.field_20953.containsKey(layer)) {
            return Collections.singleton((class_287)this.field_20953.get(layer));
        }
        return Collections.emptySet();
    }

    protected class_287 addNewFallbackBuffer(class_1921 layer) {
        class_287 bufferBuilder = BufferBuilderPool.get();
        ((ReferenceSet)this.fallbackBuffers.computeIfAbsent((Object)layer, k -> new ReferenceLinkedOpenHashSet())).add((Object)bufferBuilder);
        return bufferBuilder;
    }

    protected int getLayerOrder(class_1921 layer) {
        if (layer == null) {
            return Integer.MAX_VALUE;
        }
        if (layer instanceof class_1921.class_4687) {
            class_1921.class_4687 multiPhase = (class_1921.class_4687)layer;
            class_2960 textureId = multiPhase.method_35784().field_21406.method_23564().orElse(null);
            if (textureId != null) {
                if (textureId.toString().startsWith("minecraft:textures/entity/horse/")) {
                    String horseTexturePath = textureId.toString().substring("minecraft:textures/entity/horse/".length());
                    if (horseTexturePath.startsWith("horse_markings")) {
                        return 2;
                    }
                    if (horseTexturePath.startsWith("armor/")) {
                        return 3;
                    }
                    return 1;
                }
                if (textureId.equals((Object)class_4722.field_42071)) {
                    return 1;
                }
            }
        }
        if (!layer.field_21402) {
            return Integer.MIN_VALUE;
        }
        return 0x7FFFFFFE;
    }
}

