/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.item.loader;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import snownee.kiwi.customization.item.loader.ItemCodecs;
import snownee.kiwi.customization.item.loader.ItemDefinitionProperties;
import snownee.kiwi.customization.item.loader.KItemTemplate;
import snownee.kiwi.customization.item.loader.KItemTemplates;
import snownee.kiwi.util.resource.OneTimeLoader;

public final class SimpleItemTemplate
extends KItemTemplate {
    private final String clazz;
    private Function<class_1792.class_1793, class_1792> constructor;

    public SimpleItemTemplate(Optional<ItemDefinitionProperties> properties, String clazz) {
        super(properties);
        this.clazz = clazz;
    }

    public static Codec<SimpleItemTemplate> directCodec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ItemDefinitionProperties.mapCodecField().forGetter(KItemTemplate::properties), (App)Codec.STRING.optionalFieldOf("class", (Object)"").forGetter(SimpleItemTemplate::clazz)).apply((Applicative)instance, SimpleItemTemplate::new));
    }

    @Override
    public KItemTemplate.Type<?> type() {
        return KItemTemplates.SIMPLE.getOrCreate();
    }

    @Override
    public void resolve(class_2960 key, OneTimeLoader.Context context) {
        if (this.clazz.isEmpty()) {
            this.constructor = ItemCodecs.SIMPLE_ITEM_FACTORY;
            return;
        }
        try {
            Class<?> clazz = Class.forName(context.mappingResolver().unmapClass(this.clazz));
            this.constructor = $ -> {
                try {
                    return (class_1792)clazz.getConstructor(class_1792.class_1793.class).newInstance($);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public class_1792 createItem(class_2960 id, class_1792.class_1793 settings, JsonObject input) {
        return this.constructor.apply(settings);
    }

    public String clazz() {
        return this.clazz;
    }

    public String toString() {
        return "SimpleItemTemplate[properties=" + this.properties + ", clazz=" + this.clazz + ", constructor=" + this.constructor + "]";
    }
}

