/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import snownee.kiwi.customization.CustomizationClient;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.builder.BuilderModePreview;
import snownee.kiwi.customization.builder.BuilderRule;
import snownee.kiwi.customization.builder.ConvertScreen;
import snownee.kiwi.customization.network.CApplyBuilderRulePacket;
import snownee.kiwi.customization.network.CConvertItemPacket;
import snownee.kiwi.util.KHolder;

public class BuildersButton {
    private static final BuilderModePreview PREVIEW_RENDERER = new BuilderModePreview();
    private static boolean builderMode;

    public static BuilderModePreview getPreviewRenderer() {
        return PREVIEW_RENDERER;
    }

    public static boolean isBuilderModeOn() {
        if (builderMode && CustomizationClient.buildersButtonKey != null && CustomizationClient.buildersButtonKey.method_1415()) {
            builderMode = false;
        }
        return builderMode;
    }

    public static boolean onLongPress() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || player.method_7325()) {
            return false;
        }
        builderMode = !builderMode;
        class_5819 random = class_5819.method_43047();
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14627, (float)((random.method_43057() - random.method_43057()) * 0.35f + 0.9f)));
        return true;
    }

    public static boolean onDoublePress() {
        return false;
    }

    public static boolean onShortPress() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return false;
        }
        class_437 screen = mc.field_1755;
        if (screen instanceof ConvertScreen) {
            screen.method_25419();
            return true;
        }
        if (screen != null) {
            return false;
        }
        List<CConvertItemPacket.Group> groups = BuildersButton.findConvertGroups((class_1657)player, player.method_6047());
        if (!groups.isEmpty()) {
            mc.method_1507((class_437)new ConvertScreen(null, null, player.method_31548().field_7545, groups));
            return true;
        }
        groups = BuildersButton.findConvertGroups((class_1657)player, player.method_6079());
        if (!groups.isEmpty()) {
            mc.method_1507((class_437)new ConvertScreen(null, null, 40, groups));
            return true;
        }
        return false;
    }

    public static List<CConvertItemPacket.Group> findConvertGroups(class_1657 player, class_1799 itemStack) {
        List<KHolder<BlockFamily>> families = BlockFamilies.findQuickSwitch(itemStack.method_7909(), player.method_7337());
        if (families.isEmpty()) {
            return List.of();
        }
        ArrayList groups = Lists.newArrayListWithExpectedSize((int)families.size());
        HashSet addedItems = Sets.newHashSet();
        float ratio = BlockFamilies.getConvertRatio(itemStack.method_7909());
        for (KHolder<BlockFamily> family : families) {
            CConvertItemPacket.Group group2 = new CConvertItemPacket.Group();
            boolean cascading = family.value().switchAttrs().cascading();
            List<CConvertItemPacket.Entry> unresolved = cascading ? Lists.newLinkedList() : List.of();
            HashSet iteratedFamilies = cascading ? Sets.newHashSet((Object[])new BlockFamily[]{family.value()}) : Set.of();
            Set<class_1792> iteratedItems = cascading ? Sets.newHashSet() : Set.of();
            for (class_1792 item : family.value().items().toList()) {
                float convertRatio = BlockFamilies.getConvertRatio(item);
                CConvertItemPacket.Entry entry2 = new CConvertItemPacket.Entry(ratio / convertRatio);
                Pair pair = Pair.of(family, (Object)item);
                entry2.steps().add((Pair<KHolder<BlockFamily>, class_1792>)pair);
                if (cascading) {
                    unresolved.add(entry2);
                    iteratedItems.add(item);
                }
                if (!addedItems.contains(item)) {
                    group2.entries().add(entry2);
                }
                addedItems.add(item);
            }
            while (!unresolved.isEmpty()) {
                CConvertItemPacket.Entry parentEntry = (CConvertItemPacket.Entry)unresolved.remove(0);
                Pair<KHolder<BlockFamily>, class_1792> lastStep = parentEntry.steps().get(parentEntry.steps().size() - 1);
                class_1792 lastItem = (class_1792)lastStep.getSecond();
                ratio = BlockFamilies.getConvertRatio(lastItem);
                for (KHolder<BlockFamily> nextFamily : BlockFamilies.findQuickSwitch(lastItem, player.method_7337())) {
                    if (!iteratedFamilies.add(nextFamily.value())) continue;
                    for (class_1792 nextItem : nextFamily.value().items().toList()) {
                        if (!iteratedItems.add(nextItem)) continue;
                        float convertRatio = BlockFamilies.getConvertRatio(nextItem);
                        CConvertItemPacket.Entry entry3 = new CConvertItemPacket.Entry(parentEntry.ratio() * ratio / convertRatio);
                        entry3.steps().addAll(parentEntry.steps());
                        entry3.steps().add((Pair<KHolder<BlockFamily>, class_1792>)Pair.of(nextFamily, (Object)nextItem));
                        if (!addedItems.contains(nextItem)) {
                            group2.entries().add(entry3);
                            addedItems.add(nextItem);
                        }
                        if (entry3.steps().size() >= 4 || !nextFamily.value().switchAttrs().cascading()) continue;
                        unresolved.add(entry3);
                    }
                }
            }
            if (group2.entries().isEmpty()) continue;
            groups.add(group2);
        }
        if (player.method_7337()) {
            return groups;
        }
        Predicate<CConvertItemPacket.Entry> filter = entry -> {
            if (entry.ratio() >= 1.0f) {
                return false;
            }
            return !player.method_31548().method_43256($ -> $.method_31574(entry.item()));
        };
        int count = 0;
        for (CConvertItemPacket.Group group3 : groups) {
            group3.entries().removeIf(filter);
            count += group3.entries().size();
        }
        if (count <= 1) {
            return List.of();
        }
        groups.removeIf(group -> group.entries().isEmpty());
        return groups;
    }

    public static boolean startDestroyBlock(class_2338 pos, class_2350 face) {
        class_746 player = BuildersButton.ensureBuilderMode();
        return player != null;
    }

    public static boolean performUseItemOn(class_1268 hand, class_3965 hitResult) {
        class_746 player = BuildersButton.ensureBuilderMode();
        if (player == null) {
            return false;
        }
        if (hand == class_1268.field_5810) {
            return false;
        }
        BuilderModePreview preview = BuildersButton.getPreviewRenderer();
        KHolder<BuilderRule> rule = preview.rule;
        class_2338 pos = preview.pos;
        List<class_2338> positions = preview.positions;
        if (rule == null || positions.isEmpty() || !hitResult.method_17777().equals((Object)pos)) {
            return true;
        }
        CApplyBuilderRulePacket.send(new class_1838((class_1657)player, hand, hitResult), rule, positions);
        return true;
    }

    private static class_746 ensureBuilderMode() {
        if (!BuildersButton.isBuilderModeOn()) {
            return null;
        }
        return class_310.method_1551().field_1724;
    }

    public static void renderDebugText(List<String> left, List<String> right) {
        if (!BuildersButton.isBuilderModeOn() || class_310.method_1551().field_1690.field_1866) {
            return;
        }
        left.add("Builder Mode is on, long press %s to toggle".formatted(CustomizationClient.buildersButtonKey.method_16007().getString()));
    }

    public static boolean cancelRenderHighlight() {
        return !BuildersButton.getPreviewRenderer().positions.isEmpty();
    }
}

