/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.placement;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_2096;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.util.codec.CustomizationCodecs;

public record StatePropertiesPredicate(List<PropertyMatcher> properties) implements Predicate<class_2680>
{
    public static final Codec<StatePropertiesPredicate> CODEC = Codec.compoundList((Codec)Codec.STRING, (Codec)Codec.either(CustomizationCodecs.compactList(Codec.STRING), CustomizationCodecs.INT_BOUNDS)).xmap($ -> new StatePropertiesPredicate($.stream().map(pair -> {
        Optional strValues = ((Either)pair.getSecond()).left();
        return strValues.map(strings -> new PropertyMatcher((String)pair.getFirst(), (Either<Set<String>, class_2096.class_2100>)Either.left(Set.copyOf(strings)))).orElseGet(() -> new PropertyMatcher((String)pair.getFirst(), (Either<Set<String>, class_2096.class_2100>)Either.right((Object)((class_2096.class_2100)((Either)pair.getSecond()).right().orElseThrow()))));
    }).toList()), $ -> $.properties.stream().map(matcher -> Pair.of((Object)matcher.key, (Object)matcher.value.mapLeft(List::copyOf))).toList());

    @Override
    public boolean test(class_2680 blockState) {
        for (PropertyMatcher matcher : this.properties) {
            if (matcher.test(blockState)) continue;
            return false;
        }
        return true;
    }

    public boolean smartTest(class_2680 baseState, class_2680 targetState) {
        for (PropertyMatcher matcher : this.properties) {
            if (matcher.smartTest(baseState, targetState)) continue;
            return false;
        }
        return true;
    }

    public record PropertyMatcher(String key, Either<Set<String>, class_2096.class_2100> value) {
        public boolean test(class_2680 blockState) {
            boolean isInteger;
            class_2769<?> property = KBlockUtils.getProperty(blockState, this.key);
            Optional strValues = this.value.left();
            boolean bl = isInteger = property.method_11902() == Integer.class;
            if (strValues.isEmpty() && !isInteger) {
                throw new IllegalStateException("Property value type mismatch");
            }
            if (strValues.isEmpty()) {
                return ((class_2096.class_2100)this.value.right().orElseThrow()).method_9054(((Integer)blockState.method_11654(property)).intValue());
            }
            return ((Set)strValues.get()).contains(KBlockUtils.getValueString(blockState, this.key));
        }

        public boolean smartTest(class_2680 baseState, class_2680 targetState) {
            boolean isInteger;
            class_2769<?> property = KBlockUtils.getProperty(targetState, this.key);
            Optional strValues = this.value.left();
            boolean bl = isInteger = property.method_11902() == Integer.class;
            if (strValues.isEmpty() && !isInteger) {
                throw new IllegalStateException("Property value type mismatch");
            }
            if (strValues.isEmpty()) {
                return ((class_2096.class_2100)this.value.right().orElseThrow()).method_9054(((Integer)targetState.method_11654(property)).intValue());
            }
            String targetValue = KBlockUtils.getValueString(targetState, this.key);
            for (String s : (Set)strValues.get()) {
                String baseValue;
                if (!(s.startsWith("@") ? (baseValue = KBlockUtils.getValueString(baseState, s.substring(1))).equals(targetValue) : s.equals(targetValue))) continue;
                return true;
            }
            return false;
        }
    }
}

