/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.fabric;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.mehvahdjukaar.moonlight.api.client.model.fabric.MLFabricModelLoaderRegistry;
import net.mehvahdjukaar.moonlight.api.item.IItemDecoratorRenderer;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.fabric.ITextureAtlasSpriteExtension;
import net.mehvahdjukaar.moonlight.core.mixins.fabric.ModelManagerAccessor;
import net.mehvahdjukaar.moonlight.fabric.MoonlightFabricClient;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1100;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_5601;
import net.minecraft.class_5616;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_793;

public class ClientHelperImpl {
    public static final Map<class_1935, IItemDecoratorRenderer> ITEM_DECORATORS = new IdentityHashMap<class_1935, IItemDecoratorRenderer>();
    public static final List<Consumer<ClientHelper.ShaderEvent>> SHADER_REGISTRATIONS = new ArrayList<Consumer<ClientHelper.ShaderEvent>>();

    public static void registerRenderType(class_2248 block, class_1921 ... type) {
        BlockRenderLayerMap.INSTANCE.putBlock(block, type[0]);
    }

    public static void addParticleRegistration(Consumer<ClientHelper.ParticleEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> eventListener.accept(ClientHelperImpl::registerParticle));
    }

    private static <P extends class_2396<T>, T extends class_2394> void registerParticle(P type, ClientHelper.ParticleFactory<T> registration) {
        ParticleFactoryRegistry.getInstance().register(type, registration::create);
    }

    public static void addEntityRenderersRegistration(Consumer<ClientHelper.EntityRendererEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> eventListener.accept(EntityRendererRegistry::register));
    }

    public static void addBlockEntityRenderersRegistration(Consumer<ClientHelper.BlockEntityRendererEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> eventListener.accept(class_5616::method_32144));
    }

    public static void addBlockColorsRegistration(Consumer<ClientHelper.BlockColorEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> eventListener.accept(new ClientHelper.BlockColorEvent(){

            @Override
            public void register(class_322 color, class_2248 ... block) {
                ColorProviderRegistry.BLOCK.register((Object)color, (Object[])block);
            }

            @Override
            public int getColor(class_2680 block, class_1920 level, class_2338 pos, int tint) {
                class_322 c = (class_322)ColorProviderRegistry.BLOCK.get((Object)block.method_26204());
                return c == null ? -1 : c.getColor(block, level, pos, tint);
            }
        }));
    }

    public static void addItemColorsRegistration(Consumer<ClientHelper.ItemColorEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> eventListener.accept(new ClientHelper.ItemColorEvent(){

            @Override
            public void register(class_326 color, class_1935 ... items) {
                ColorProviderRegistry.ITEM.register((Object)color, (Object[])items);
            }

            @Override
            public int getColor(class_1799 stack, int tint) {
                class_326 c = (class_326)ColorProviderRegistry.ITEM.get((Object)stack.method_7909());
                return c == null ? -1 : c.getColor(stack, tint);
            }
        }));
    }

    public static void addClientReloadListener(final Supplier<class_3302> listener, final class_2960 name) {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener(new IdentifiableResourceReloadListener(){
            private final Supplier<class_3302> inner = Suppliers.memoize(((Supplier)listener)::get);

            public class_2960 getFabricId() {
                return name;
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return this.inner.get().method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            }
        });
    }

    public static void addItemDecoratorsRegistration(Consumer<ClientHelper.ItemDecoratorEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> eventListener.accept(ITEM_DECORATORS::put));
    }

    public static void addModelLayerRegistration(Consumer<ClientHelper.ModelLayerEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> eventListener.accept((a, b) -> EntityModelLayerRegistry.registerModelLayer((class_5601)a, ((Supplier)b)::get)));
    }

    public static void addSpecialModelRegistration(Consumer<ClientHelper.SpecialModelEvent> eventListener) {
        Moonlight.assertInitPhase();
        ModelLoadingPlugin.register(pluginContext -> eventListener.accept(xva$0 -> pluginContext.addModels(new class_2960[]{xva$0})));
    }

    public static void addTooltipComponentRegistration(Consumer<ClientHelper.TooltipComponentEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> eventListener.accept(ClientHelperImpl::tooltipReg));
    }

    private static <T extends class_5632> void tooltipReg(Class<T> tClass, Function<? super T, ? extends class_5684> factory) {
        TooltipComponentCallback.EVENT.register(data -> tClass.isAssignableFrom(data.getClass()) ? (class_5684)factory.apply(data) : null);
    }

    public static void addModelLoaderRegistration(Consumer<ClientHelper.ModelLoaderEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> eventListener.accept(MLFabricModelLoaderRegistry::registerLoader));
    }

    public static void addKeyBindRegistration(Consumer<ClientHelper.KeyBindEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> eventListener.accept(KeyBindingHelper::registerKeyBinding));
    }

    public static int getPixelRGBA(class_1058 sprite, int frameIndex, int x, int y) {
        return ((ITextureAtlasSpriteExtension)sprite).getPixelRGBA(frameIndex, x, y);
    }

    public static class_1087 getModel(class_1092 modelManager, class_2960 modelLocation) {
        return ((ModelManagerAccessor)modelManager).getBakedRegistry().getOrDefault(modelLocation, modelManager.method_4744());
    }

    public static Path getModIcon(String modId) {
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer(modId).get();
        return container.getMetadata().getIconPath(512).flatMap(arg_0 -> ((ModContainer)container).findPath(arg_0)).orElse(null);
    }

    public static class_793 parseBlockModel(JsonElement json) {
        return class_793.method_3430((String)json.toString());
    }

    public static void addClientSetup(Runnable clientSetup) {
        Moonlight.assertInitPhase();
        MoonlightFabricClient.CLIENT_SETUP_WORK.add(clientSetup);
    }

    public static void addClientSetupAsync(Runnable clientSetup) {
        ClientHelperImpl.addClientSetup(clientSetup);
    }

    public static void registerFluidRenderType(class_3611 fluid, class_1921 type) {
        BlockRenderLayerMap.INSTANCE.putFluid(fluid, type);
    }

    public static void registerOptionalTexturePack(class_2960 folderName, class_2561 displayName, boolean defaultEnabled) {
        Moonlight.assertInitPhase();
        if (!PlatHelper.isDev()) {
            FabricLoader.getInstance().getModContainer(folderName.method_12836()).ifPresent(c -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)folderName, (ModContainer)c, (class_2561)displayName, (ResourcePackActivationType)(defaultEnabled ? ResourcePackActivationType.DEFAULT_ENABLED : ResourcePackActivationType.NORMAL)));
        }
    }

    public static class_1100 getUnbakedModel(class_1092 modelManager, class_2960 modelLocation) {
        return null;
    }

    public static void addShaderRegistration(Consumer<ClientHelper.ShaderEvent> eventListener) {
        Moonlight.assertInitPhase();
        SHADER_REGISTRATIONS.add(eventListener);
    }
}

