/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Stopwatch;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.events.EarlyPackReloadEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_6862;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynResourceGenerator<T extends DynamicResourcePack>
implements class_3302 {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    public final T dynamicPack;
    protected final String modId;
    private boolean hasBeenInitialized;
    private static final Set<DynResourceGenerator<?>> GENERATORS = new HashSet();

    protected DynResourceGenerator(T pack, String modId) {
        this.dynamicPack = pack;
        this.modId = modId;
        ((DynamicResourcePack)this.dynamicPack).registerPack();
        GENERATORS.add(this);
    }

    public final void register() {
    }

    public abstract Logger getLogger();

    public T getPack() {
        return this.dynamicPack;
    }

    public boolean shouldClearOnReload() {
        return this.runsOnEveryReload();
    }

    public boolean runsOnEveryReload() {
        return true;
    }

    private void regenerateDynamicAssets(class_3300 manager, IProgressTracker progressTracker) {
        ArrayList genTasks = new ArrayList();
        this.regenerateDynamicAssets(manager);
        this.regenerateDynamicAssets(genTasks::add);
        Stopwatch watch = Stopwatch.createStarted();
        int totalTasks = genTasks.size();
        IProgressTracker.Task reporter = progressTracker.subtask(totalTasks);
        List<CompletableFuture> futures = genTasks.stream().map(task -> CompletableFuture.supplyAsync(() -> {
            ResourceSink localSink = this.createLocalSink();
            task.accept(manager, localSink);
            reporter.step();
            return localSink;
        }, this.getExecutors())).toList();
        CompletableFuture<Void> allDone = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        try {
            allDone.join();
            this.getLogger().info("Tasks finished in: {} ms", (Object)watch.elapsed().toMillis());
            this.addAllResourceSinks(futures.stream().map(CompletableFuture::join).toList());
        }
        catch (Exception e) {
            throw new RuntimeException("Task failed", e);
        }
        this.getLogger().info("Generated runtime {} for pack {} ({}) in: {} ms{} (multithreaded)", (Object)((DynamicResourcePack)this.dynamicPack).getPackType(), (Object)((DynamicResourcePack)this.dynamicPack).method_14409(), (Object)this.modId, (Object)watch.elapsed().toMillis(), (Object)(((DynamicResourcePack)this.dynamicPack).generateDebugResources ? " (debug resource dump on)" : ""));
    }

    protected void addAllResourceSinks(List<ResourceSink> sinks) {
        HashMap allTags = new HashMap();
        for (ResourceSink resourceSink : sinks) {
            resourceSink.resources.forEach((arg_0, arg_1) -> this.dynamicPack.addBytes(arg_0, arg_1));
            resourceSink.notClearable.forEach(arg_0 -> this.dynamicPack.markNotClearable(arg_0));
            for (Map.Entry<class_6862<?>, SimpleTagBuilder> e : resourceSink.tags.entrySet()) {
                allTags.merge(e.getKey(), e.getValue(), SimpleTagBuilder::merge);
            }
        }
        for (Map.Entry entry : allTags.entrySet()) {
            ((DynamicResourcePack)this.dynamicPack).addTag((SimpleTagBuilder)((Object)entry.getValue()), ((class_6862)entry.getKey()).comp_326());
        }
    }

    @NotNull
    protected ResourceSink createLocalSink() {
        return new ResourceSink(this.modId, ((DynamicResourcePack)this.dynamicPack).method_14409());
    }

    @NotNull
    protected ExecutorService getExecutors() {
        return EXECUTOR_SERVICE;
    }

    @Deprecated(forRemoval=true)
    public void regenerateDynamicAssets(class_3300 manager) {
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
    }

    @NotNull
    public final CompletableFuture<Void> method_25931(class_3302.class_4045 stage, class_3300 manager, class_3695 workerProfiler, class_3695 mainProfiler, Executor workerExecutor, Executor mainExecutor) {
        if (PlatHelper.isModLoadingValid()) {
            this.onNormalReload(manager);
        } else {
            Moonlight.LOGGER.error("Cowardly refusing generate assets for a broken mod state");
        }
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> null, workerExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0))).thenAcceptAsync(noResult -> {}, mainExecutor);
    }

    protected void onNormalReload(class_3300 manager) {
    }

    protected final void onEarlyReload(EarlyPackReloadEvent event, IProgressTracker localReporter) {
        if (event.type() == ((DynamicResourcePack)this.dynamicPack).packType) {
            try {
                this.reloadResources(event.manager(), localReporter);
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("An error occurred while trying to generate dynamic assets for {}:", this.dynamicPack, (Object)e);
            }
        }
    }

    protected final void reloadResources(class_3300 manager, IProgressTracker reporter) {
        boolean wasFirstReload = false;
        if (!this.hasBeenInitialized) {
            wasFirstReload = true;
            this.hasBeenInitialized = true;
            T t = this.dynamicPack;
            if (t instanceof DynamicTexturePack) {
                DynamicTexturePack tp = (DynamicTexturePack)t;
                tp.addPackLogo();
            }
        }
        if (this.runsOnEveryReload() || wasFirstReload) {
            this.regenerateDynamicAssets(manager, reporter);
        }
    }

    @Nullable
    protected abstract class_3283 getRepository();

    @Deprecated(forRemoval=true)
    public boolean alreadyHasAssetAtLocation(class_3300 manager, class_2960 res, ResType type) {
        return this.alreadyHasAssetAtLocation(manager, type.getPath(res));
    }

    @Deprecated(forRemoval=true)
    public boolean alreadyHasAssetAtLocation(class_3300 manager, class_2960 res) {
        Optional resource = manager.method_14486(res);
        return resource.filter(value -> !value.method_14480().equals(((DynamicResourcePack)this.dynamicPack).method_14409())).isPresent();
    }

    @Deprecated(forRemoval=true)
    public void addSimilarJsonResource(class_3300 manager, StaticResource resource, String keyword, String replaceWith) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, s -> s.replace(keyword, replaceWith));
    }

    @Deprecated(forRemoval=true)
    public void addSimilarJsonResource(class_3300 manager, StaticResource resource, Function<String, String> textTransform) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, textTransform, textTransform);
    }

    @Deprecated(forRemoval=true)
    public void addSimilarJsonResource(class_3300 manager, StaticResource resource, Function<String, String> textTransform, Function<String, String> pathTransform) throws NoSuchElementException {
        class_2960 fullPath = resource.location;
        StringBuilder builder = new StringBuilder();
        String[] partial = fullPath.method_12832().split("/");
        for (int i = 0; i < partial.length; ++i) {
            if (i != 0) {
                builder.append("/");
            }
            if (i == partial.length - 1) {
                builder.append(pathTransform.apply(partial[i]));
                continue;
            }
            builder.append(partial[i]);
        }
        class_2960 newRes = new class_2960(this.modId, builder.toString());
        if (!this.alreadyHasAssetAtLocation(manager, newRes)) {
            String fullText = new String(resource.data, StandardCharsets.UTF_8);
            fullText = textTransform.apply(fullText);
            ((DynamicResourcePack)this.dynamicPack).addBytes(newRes, fullText.getBytes());
        }
    }

    @Deprecated(forRemoval=true)
    public void addResourceIfNotPresent(class_3300 manager, StaticResource resource) {
        if (!this.alreadyHasAssetAtLocation(manager, resource.location)) {
            ((DynamicResourcePack)this.dynamicPack).addResource(resource);
        }
    }

    @ApiStatus.Internal
    public static void clearAfterReload(class_3264 targetType) {
        HashSet packs = new HashSet();
        for (DynResourceGenerator<?> g : GENERATORS) {
            if (((DynamicResourcePack)g.dynamicPack).packType != targetType || !g.shouldClearOnReload()) continue;
            packs.add(g.dynamicPack);
        }
        for (DynamicResourcePack p : packs) {
            p.clearNonStatic();
        }
    }

    @ApiStatus.Internal
    public static void clearBeforeReload(class_3264 targetType) {
        HashSet packs = new HashSet();
        for (DynResourceGenerator<?> g : GENERATORS) {
            if (((DynamicResourcePack)g.dynamicPack).packType != targetType || !g.shouldClearOnReload()) continue;
            packs.add(g.dynamicPack);
        }
        for (DynamicResourcePack p : packs) {
            p.clearAllContent();
        }
    }

    static {
        MoonlightEventsHelper.addListener(earlyPackReloadEvent -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            List<DynResourceGenerator> validGen = GENERATORS.stream().filter(gen -> ((DynamicResourcePack)gen.dynamicPack).packType == earlyPackReloadEvent.type()).toList();
            IProgressTracker reporter = earlyPackReloadEvent.progress();
            for (DynResourceGenerator gen2 : validGen) {
                gen2.onEarlyReload((EarlyPackReloadEvent)earlyPackReloadEvent, reporter);
            }
            Moonlight.LOGGER.info("Generated runtime resources for {} packs in a total of: {} ms", (Object)GENERATORS.size(), (Object)stopwatch.elapsed().toMillis());
        }, EarlyPackReloadEvent.class);
    }
}

