/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.textures.ImageTransformer;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.class_1011;
import net.minecraft.class_1079;
import net.minecraft.class_1080;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5253;
import net.minecraft.class_7771;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextureImage
implements AutoCloseable {
    @Nullable
    private final McMetaFile metadata;
    private final class_1011 image;
    private final class_7771 frameSize;
    private final int frameCount;
    private final int frameScale;

    private TextureImage(class_1011 image, @Nullable McMetaFile metadata) {
        this.image = image;
        this.metadata = metadata;
        int imgWidth = this.imageWidth();
        int imgHeight = this.imageHeight();
        this.frameSize = metadata == null ? new class_7771(imgWidth, imgHeight) : metadata.animation().method_24143(imgWidth, imgHeight);
        this.frameScale = imgWidth / this.frameSize.comp_1049();
        int frameScaleHeight = imgHeight / this.frameSize.comp_1050();
        this.frameCount = this.frameScale * frameScaleHeight;
    }

    public void forEachFramePixel(FramePixelConsumer framePixelConsumer) {
        for (int ind = 0; ind < this.frameCount; ++ind) {
            int xOff = this.getFrameStartX(ind);
            int yOff = this.getFrameStartY(ind);
            for (int x = 0; x < this.frameWidth(); ++x) {
                for (int y = 0; y < this.frameHeight(); ++y) {
                    framePixelConsumer.accept(ind, x + xOff, y + yOff);
                }
            }
        }
    }

    @Deprecated(forRemoval=true)
    public void forEachFrame(FramePixelConsumer e) {
        this.forEachFramePixel(e);
    }

    public void toGrayscale() {
        SpriteUtils.grayscaleImage(this.image);
    }

    public RGBColor getAverageColor() {
        return SpriteUtils.averageColor(this.image);
    }

    public int frameWidth() {
        return this.frameSize.comp_1049();
    }

    public int frameHeight() {
        return this.frameSize.comp_1050();
    }

    public int getFrameStartX(int frameIndex) {
        return frameIndex % this.frameScale * this.frameWidth();
    }

    public int getFrameStartY(int frameIndex) {
        return frameIndex / this.frameScale * this.frameHeight();
    }

    public int getFramePixel(int frameIndex, int x, int y) {
        return this.image.method_4315(this.getFrameStartX(frameIndex) + x, this.getFrameStartY(frameIndex) + y);
    }

    public void setFramePixel(int frameIndex, int x, int y, int color) {
        this.image.method_4305(this.getFrameStartX(frameIndex) + x, this.getFrameStartY(frameIndex) + y, color);
    }

    public class_1011 getImage() {
        return this.image;
    }

    public int frameCount() {
        return this.frameCount;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public class_1079 getMetadata() {
        return this.metadata == null ? null : this.metadata.animation();
    }

    public McMetaFile getMcMeta() {
        return this.metadata;
    }

    public TextureImage makeCopy() {
        class_1011 im = new class_1011(this.imageWidth(), this.imageHeight(), false);
        im.method_4317(this.image);
        return new TextureImage(im, this.metadata);
    }

    public TextureImage createAnimationTemplate(int length, McMetaFile useDataFrom) {
        McMetaFile newMetadata = useDataFrom.cloneWithSize(this.frameWidth(), this.frameHeight());
        class_1011 im = new class_1011(this.frameWidth(), this.frameHeight() * length, false);
        TextureImage t = new TextureImage(im, newMetadata);
        t.forEachFramePixel((i, x, y) -> {
            int xo = this.getFrameX(i, x);
            int yo = this.getFrameY(i, y);
            t.image.method_4305(x.intValue(), y.intValue(), this.image.method_4315(xo, yo));
        });
        return t;
    }

    @Deprecated(forRemoval=true)
    public TextureImage createAnimationTemplate(int length, @NotNull class_1079 useDataFrom) {
        return this.createAnimationTemplate(length, McMetaFile.of(useDataFrom));
    }

    @Deprecated(forRemoval=true)
    public TextureImage createAnimationTemplate(int length, List<class_1080> frameData, int frameTime, boolean interpolate) {
        return this.createAnimationTemplate(length, new class_1079(frameData, this.frameWidth(), this.frameHeight(), frameTime, interpolate));
    }

    public static TextureImage open(class_3300 manager, class_2960 relativePath) throws IOException {
        try {
            if (relativePath.method_12832().endsWith(".png")) {
                relativePath = relativePath.method_45136(relativePath.method_12832().substring(0, relativePath.method_12832().length() - 4));
            }
            class_2960 textureLoc = ResType.TEXTURES.getPath(relativePath);
            class_1011 i = SpriteUtils.readImage(manager, textureLoc);
            class_2960 metadataLoc = ResType.MCMETA.getPath(relativePath);
            McMetaFile metadata = null;
            Optional res = manager.method_14486(metadataLoc);
            if (res.isPresent()) {
                try {
                    metadata = McMetaFile.read((class_3298)res.get());
                }
                catch (Exception e) {
                    throw new IOException("Failed to open texture at location " + String.valueOf(relativePath) + ": failed to read mcmeta file", e);
                }
            }
            return new TextureImage(i, metadata);
        }
        catch (Exception e) {
            throw new IOException("Failed to open texture at location " + String.valueOf(relativePath) + ": no such file");
        }
    }

    public static TextureImage createNew(int width, int height) {
        return TextureImage.createNew(width, height, (McMetaFile)null);
    }

    public static TextureImage createNew(int width, int height, @Nullable McMetaFile metadata) {
        TextureImage v = new TextureImage(new class_1011(width, height, false), metadata);
        v.clear();
        return v;
    }

    @Deprecated(forRemoval=true)
    public static TextureImage createNew(int width, int height, @Nullable class_1079 animation) {
        return TextureImage.createNew(width, height, animation == null ? null : McMetaFile.of(animation));
    }

    public static TextureImage createMask(TextureImage original, Palette palette) {
        TextureImage copy = original.makeCopy();
        class_1011 nativeImage = copy.getImage();
        SpriteUtils.forEachPixel(nativeImage, (x, y) -> {
            int color = nativeImage.method_4315(x.intValue(), y.intValue());
            if (palette.hasColor(color)) {
                nativeImage.method_4305(x.intValue(), y.intValue(), 0);
            } else {
                nativeImage.method_4305(x.intValue(), y.intValue(), -16777216);
            }
        });
        return copy;
    }

    public TextureImage createResized(float widthScale, float heightScale) {
        int newW = (int)((float)this.imageWidth() * widthScale);
        int newH = (int)((float)this.imageHeight() * heightScale);
        McMetaFile meta = null;
        if (this.metadata != null) {
            int mW = (int)((float)this.metadata.animation().field_5338 * widthScale);
            int mH = (int)((float)this.metadata.animation().field_5336 * heightScale);
            meta = this.metadata.cloneWithSize(mW, mH);
        }
        TextureImage im = TextureImage.createNew(newW, newH, meta);
        ImageTransformer t = ImageTransformer.builder(this.frameWidth(), this.frameHeight(), im.frameWidth(), im.frameHeight()).copyRect(0, 0, this.frameWidth(), this.frameHeight(), 0, 0).build();
        t.apply(this, im);
        return im;
    }

    public void clear() {
        this.image.method_4326(0, 0, this.image.method_4307(), this.image.method_4323(), 0);
    }

    @Deprecated(forRemoval=true)
    public static TextureImage of(class_1011 image, @Nullable class_1079 animation) {
        return new TextureImage(image, animation == null ? null : McMetaFile.of(animation));
    }

    public static TextureImage of(class_1011 image) {
        return new TextureImage(image, null);
    }

    public static TextureImage of(class_1011 image, @Nullable McMetaFile metadata) {
        return new TextureImage(image, metadata);
    }

    @Override
    public void close() {
        this.image.close();
    }

    public int imageWidth() {
        return this.image.method_4307();
    }

    public int imageHeight() {
        return this.image.method_4323();
    }

    public ImmutableList<class_1011> splitFrames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.metadata == null) {
            builder.add((Object)this.image);
            return builder.build();
        }
        int imgWidth = this.imageWidth();
        int imgHeight = this.imageHeight();
        class_7771 fs = this.metadata.animation().method_24143(imgWidth, imgHeight);
        int frameScaleWidth = imgWidth / fs.comp_1049();
        int frameScaleHeight = imgHeight / fs.comp_1050();
        int maxFrames = frameScaleWidth * frameScaleHeight;
        ArrayList indexList = Lists.newArrayList();
        this.metadata.animation().method_33460((index, time) -> indexList.add(index));
        if (indexList.isEmpty()) {
            for (int l = 0; l < maxFrames; ++l) {
                indexList.add(l);
            }
        }
        if (indexList.size() <= 1) {
            builder.add((Object)this.image);
        } else {
            Iterator iterator = indexList.iterator();
            while (iterator.hasNext()) {
                int index2 = (Integer)iterator.next();
                int xOffset = index2 % frameScaleWidth * this.frameWidth();
                int yOffset = index2 / frameScaleWidth * this.frameHeight();
                if (index2 < 0 || xOffset + this.frameWidth() >= imgWidth || yOffset + this.frameHeight() >= imgHeight) continue;
                class_1011 f = new class_1011(this.frameWidth(), this.frameHeight(), false);
                for (int x = 0; x < this.frameWidth(); ++x) {
                    for (int y = 0; y < this.frameHeight(); ++y) {
                        f.method_4305(x, y, this.image.method_4315(x + xOffset, y + yOffset));
                    }
                }
                builder.add((Object)f);
            }
        }
        return builder.build();
    }

    private void applyOverlay(boolean onlyOnExisting, TextureImage ... overlays) throws IllegalStateException {
        for (TextureImage o : overlays) {
            if (o.frameWidth() < this.frameWidth()) {
                throw new IllegalStateException("Could not apply overlay onto images because overlay was too small (overlay W: " + o.frameWidth() + ", image W: " + this.frameWidth());
            }
            if (o.frameHeight() >= this.frameHeight()) continue;
            throw new IllegalStateException("Could not apply overlay onto images because overlay was too small (overlay H: " + o.frameHeight() + ", image H: " + this.frameHeight());
        }
        for (TextureImage o : overlays) {
            this.forEachFramePixel((frameIndex, globalX, globalY) -> {
                int frameX = this.getFrameX(frameIndex, globalX);
                int frameY = this.getFrameY(frameIndex, globalY);
                int targetOverlayFrame = Math.min(frameIndex, o.frameCount - 1);
                int overlayPixel = o.getFramePixel(targetOverlayFrame, frameX, frameY);
                if (onlyOnExisting && class_5253.class_8045.method_48342((int)overlayPixel) == 0) {
                    return;
                }
                this.image.method_35624(globalX.intValue(), globalY.intValue(), overlayPixel);
            });
            o.close();
        }
    }

    private int getFrameY(Integer frameIndex, Integer globalY) {
        return globalY - this.getFrameStartY(frameIndex);
    }

    private int getFrameX(Integer frameIndex, Integer globalX) {
        return globalX - this.getFrameStartX(frameIndex);
    }

    public void applyOverlay(TextureImage ... overlays) throws IllegalStateException {
        this.applyOverlay(false, overlays);
    }

    public void applyOverlayOnExisting(TextureImage ... overlays) throws IllegalStateException {
        this.applyOverlay(true, overlays);
    }

    public void removeAlpha(int backgroundColor) {
        for (int x = 0; x < this.image.method_4307(); ++x) {
            for (int y = 0; y < this.image.method_4323(); ++y) {
                int oldValue = this.image.method_4315(x, y);
                int a = class_5253.class_8045.method_48342((int)oldValue);
                if (a == 0) {
                    this.image.method_4305(x, y, backgroundColor);
                    continue;
                }
                this.image.method_4305(x, y, class_5253.class_8045.method_48344((int)255, (int)class_5253.class_8045.method_48347((int)oldValue), (int)class_5253.class_8045.method_48346((int)oldValue), (int)class_5253.class_8045.method_48345((int)oldValue)));
            }
        }
    }

    public void crop(TextureImage mask) {
        this.crop(mask, true);
    }

    public void crop(TextureImage mask, boolean discardInner) {
        int width = this.imageWidth();
        int height = this.imageHeight();
        if (mask.imageHeight() < height || mask.imageWidth() < width) {
            throw new IllegalStateException("Could not merge images because they had different dimensions");
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (class_5253.class_8045.method_48342((int)mask.image.method_4315(x, y)) != 0 != discardInner) continue;
                this.image.method_4305(x, y, 0);
            }
        }
        mask.close();
    }

    public TextureImage createRotated(class_2470 rotation) {
        TextureImage flippedImage = TextureImage.createNew(this.frameHeight(), this.frameWidth() * this.frameCount, this.metadata);
        this.forEachFramePixel((frameIndex, globalX, globalY) -> {
            int frameX = this.getFrameX(frameIndex, globalX);
            int frameY = this.getFrameY(frameIndex, globalY);
            int newFrameX = frameX;
            int newFrameY = frameY;
            int frameWidth = this.frameWidth();
            int frameHeight = this.frameHeight();
            if (rotation == class_2470.field_11463) {
                newFrameX = frameHeight - frameY - 1;
                newFrameY = frameX;
            } else if (rotation == class_2470.field_11464) {
                newFrameX = frameWidth - frameX - 1;
                newFrameY = frameHeight - frameY - 1;
            } else if (rotation == class_2470.field_11465) {
                newFrameX = frameY;
                newFrameY = frameWidth - frameX - 1;
            }
            int newGlobalX = flippedImage.getFrameStartX(frameIndex) + newFrameX;
            int newGlobalY = flippedImage.getFrameStartY(frameIndex) + newFrameY;
            int pixel = this.getImage().method_4315(globalX.intValue(), globalY.intValue());
            flippedImage.getImage().method_4305(newGlobalX, newGlobalY, pixel);
        });
        return flippedImage;
    }

    @FunctionalInterface
    public static interface FramePixelConsumer
    extends TriConsumer<Integer, Integer, Integer> {
        public void accept(Integer var1, Integer var2, Integer var3);
    }
}

