/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.leaves;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.DebugBlockTypes;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.ClientConfigs;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeavesType
extends BlockType {
    public static final Codec<LeavesType> CODEC = class_2960.field_25139.flatXmap(r -> {
        LeavesType w = (LeavesType)LeavesTypeRegistry.INSTANCE.get((class_2960)r);
        if (w == null) {
            return DataResult.error(() -> "No such leaves type: " + String.valueOf(r));
        }
        return DataResult.success((Object)w);
    }, t -> DataResult.success((Object)t.id));
    public final class_2248 leaves;

    protected LeavesType(class_2960 id, class_2248 leaves) {
        super(id);
        this.leaves = leaves;
        if (ClientConfigs.LEAVESTYPE_DEBUG.get().booleanValue() && !this.isVanilla()) {
            DebugBlockTypes.appendToDebugFile(this.getTranslationKey());
        }
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public WoodType getWoodType() {
        WoodType w = this.getAssociatedWoodType();
        if (w == null) {
            return WoodTypeRegistry.OAK_TYPE;
        }
        return w;
    }

    @Nullable
    public WoodType getAssociatedWoodType() {
        return LeavesTypeRegistry.INSTANCE.getEquivalentWoodType(this);
    }

    @Override
    public class_1935 mainChild() {
        return this.leaves;
    }

    @Override
    public String getTranslationKey() {
        return "leaves_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("leaves", this.leaves);
    }

    @Override
    public void initializeChildrenItems() {
        this.addChild("sapling", this.findRelatedEntry("sapling", class_7923.field_41178));
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<LeavesType> {
        private Supplier<class_2248> leavesFinder;

        public Finder(class_2960 id) {
            super(id);
            this.leavesSuffix("_leaves");
        }

        public Finder leaves(Supplier<class_2248> planksFinder) {
            this.leavesFinder = planksFinder;
            return this;
        }

        public Finder leaves(class_2960 id) {
            return this.leaves(() -> (class_2248)class_7923.field_41175.method_17966(id).orElseThrow(() -> new IllegalStateException("Failed to find leaves block: " + String.valueOf(id))));
        }

        public Finder leavesAffix(String prefix, String suffix) {
            return this.leaves(prefix + this.id.method_12832() + suffix);
        }

        public Finder leavesSuffix(String suffix) {
            return this.leaves(this.id.method_12832() + suffix);
        }

        public Finder leaves(String leavesName) {
            return this.leaves(Utils.idWithOptionalNamespace(leavesName, this.id.method_12836()));
        }

        public Finder equivalentWood(String id) {
            LeavesTypeRegistry.INSTANCE.addLeavesToWoodMapping(this.id, new class_2960(id));
            return this;
        }

        @Override
        public Optional<LeavesType> get() {
            if (PlatHelper.isModLoaded(this.id.method_12836())) {
                try {
                    class_2248 leaves = (class_2248)Preconditions.checkNotNull((Object)this.leavesFinder.get(), (String)"Manual finder {} did not find a Leaf Block", (Object)this.id);
                    LeavesType w = new LeavesType(this.id, leaves);
                    this.childNames.forEach((key, value) -> {
                        try {
                            class_1935 obj = (class_1935)Preconditions.checkNotNull((Object)((class_1935)value.get()));
                            w.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            Moonlight.LOGGER.warn("Failed to find child for wood type {}: {}. Ignoring", (Object)this.id, key, (Object)e);
                        }
                    });
                    return Optional.of(w);
                }
                catch (Exception e) {
                    Moonlight.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }

        @Deprecated(forRemoval=true)
        public Finder(class_2960 id, Supplier<class_2248> leaves, @Nullable Supplier<WoodType> wood) {
            this(id, leaves);
        }

        @Deprecated(forRemoval=true)
        public Finder(class_2960 id, Supplier<class_2248> leaves) {
            super(id);
            this.leavesFinder = leaves;
        }

        @Deprecated(forRemoval=true)
        public static Finder simple(String modId, String leavesTypeName, String leavesName) {
            return new Finder(new class_2960(modId, leavesTypeName), () -> (class_2248)class_7923.field_41175.method_10223(new class_2960(modId, leavesName)), null);
        }

        @Deprecated(forRemoval=true)
        public static Finder simple(String modId, String leavesTypeName, String leavesName, String woodTypeID) {
            class_2960 leavesId = new class_2960(modId, leavesName);
            LeavesTypeRegistry.INSTANCE.addLeavesToWoodMapping(leavesId, new class_2960(woodTypeID));
            return new Finder(new class_2960(modId, leavesTypeName), () -> (class_2248)class_7923.field_41175.method_10223(leavesId));
        }

        @Deprecated(forRemoval=true)
        public void addChild(String childType, String childName) {
            this.addChild(childType, new class_2960(this.id.method_12836(), childName));
        }

        @Deprecated(forRemoval=true)
        public void addChild(String childType, class_2960 childName) {
            this.childBlock(childType, childName);
        }
    }
}

