/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.DebugBlockTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.ClientConfigs;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1743;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2478;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_7713;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodType
extends BlockType {
    public static final Codec<WoodType> CODEC = class_2960.field_25139.flatXmap(r -> {
        WoodType w = (WoodType)WoodTypeRegistry.INSTANCE.get((class_2960)r);
        if (w == null) {
            return DataResult.error(() -> "No such wood type: " + String.valueOf(r));
        }
        return DataResult.success((Object)w);
    }, t -> DataResult.success((Object)t.id));
    public final class_2248 planks;
    public final class_2248 log;
    private final Supplier<class_4719> vanillaType = Suppliers.memoize(this::detectVanillaWood);

    @Nullable
    private class_4719 detectVanillaWood() {
        Object object = this.getChild("hanging_sign");
        if (object instanceof class_7713) {
            class_7713 c = (class_7713)object;
            return c.method_24025();
        }
        object = this.getChild("sign");
        if (object instanceof class_2478) {
            class_2478 f = (class_2478)object;
            return f.method_24025();
        }
        String i = this.id.method_12836().equals("minecraft") ? this.id.method_12832() : this.id.toString();
        Stream values = class_4719.method_24026();
        Optional<class_4719> o = values.filter(v -> v.comp_1299().equals(i)).findAny();
        return o.orElse(null);
    }

    public WoodType(class_2960 id, class_2248 baseBlock, class_2248 logBlock) {
        super(id);
        this.planks = baseBlock;
        this.log = logBlock;
        if (ClientConfigs.WOODTYPE_DEBUG.get().booleanValue() && !this.isVanilla()) {
            DebugBlockTypes.appendToDebugFile(this.getTranslationKey());
        }
    }

    @Override
    public class_1935 mainChild() {
        return this.planks;
    }

    @Nullable
    public class_4719 toVanilla() {
        return this.vanillaType.get();
    }

    @NotNull
    public class_4719 toVanillaOrOak() {
        class_4719 v = this.toVanilla();
        if (v != null) {
            return v;
        }
        return class_4719.field_21676;
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getTypeName();
        }
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.planks.method_9564().method_50011();
    }

    public class_3620 getColor() {
        return this.planks.method_26403();
    }

    @Override
    public String getTranslationKey() {
        return "wood_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("planks", this.planks);
        this.addChild("log", this.log);
        this.addChild("leaves", this.findRelatedEntry("leaves", class_7923.field_41175));
        this.addChild("wood", this.findLogRelatedBlock("", "wood", "hyphae", "bark"));
        this.addChild("stripped_log", this.findStrippedLog("log", "stem", "stalk"));
        this.addChild("stripped_wood", this.findStrippedLog("wood", "hyphae", "bark"));
        this.addChild("slab", this.findRelatedEntry("slab", class_7923.field_41175));
        this.addChild("stairs", this.findRelatedEntry("stairs", class_7923.field_41175));
        class_2248 fence = (class_2248)this.findRelatedEntry("fence", class_7923.field_41175);
        this.addChild("fence", fence);
        this.addChild("fence_gate", this.findRelatedEntry("fence_gate", class_7923.field_41175));
        this.addChild("door", this.findRelatedEntry("door", class_7923.field_41175));
        this.addChild("trapdoor", this.findRelatedEntry("trapdoor", class_7923.field_41175));
        this.addChild("button", this.findRelatedEntry("button", class_7923.field_41175));
        this.addChild("pressure_plate", this.findRelatedEntry("pressure_plate", class_7923.field_41175));
        this.addChild("hanging_sign", this.findRelatedEntry("hanging_sign", class_7923.field_41175));
        this.addChild("wall_hanging_sign", this.findRelatedEntry("wall_hanging_sign", class_7923.field_41175));
        this.addChild("sign", this.findRelatedEntry("sign", class_7923.field_41175));
        this.addChild("wall_sign", this.findRelatedEntry("wall_sign", class_7923.field_41175));
        if (this.id.method_12836().matches("tfc|afc")) {
            this.addChild("sign", this.findRelatedEntry("sign", "", (class_2378)class_7923.field_41175));
            this.addChild("hanging_sign", this.findRelatedEntry("hanging_sign/wrought_sign", "", (class_2378)class_7923.field_41175));
        }
        if (fence != null && CompatHandler.DIAGONALFENCES) {
            Optional diagonalFence = class_7923.field_41175.method_17966(new class_2960("diagonalfences", Utils.getID(fence).toString().replace(":", "/")));
            diagonalFence.ifPresent(block -> this.addChild("diagonalfences:fence", block));
        }
    }

    @Override
    public void initializeChildrenItems() {
        this.addChild("boat", this.findRelatedEntry("boat", class_7923.field_41178));
        this.addChild("chest_boat", this.findRelatedEntry("chest_boat", class_7923.field_41178));
        this.addChild("sapling", this.findRelatedEntry("sapling", class_7923.field_41178));
        if (this.id.method_12836().matches("tfc|afc")) {
            this.addChild("stick", this.findRelatedEntry("twig", class_7923.field_41175));
            this.addChild("boat", this.findRelatedEntry("boat", "", (class_2378)class_7923.field_41175));
        }
    }

    @Override
    @Nullable
    protected <V> V findRelatedEntry(String prefix, String suffix, class_2378<V> reg) {
        if (!((String)suffix).isEmpty()) {
            suffix = "_" + (String)suffix;
        }
        class_2960[] targets = new class_2960[]{new class_2960(this.id.method_12836(), this.id.method_12832() + "_" + prefix + (String)suffix), new class_2960(this.id.method_12836(), prefix + "_" + this.id.method_12832() + (String)suffix), new class_2960(this.id.method_12836(), this.id.method_12832() + "_planks_" + prefix + (String)suffix), new class_2960(this.id.method_12836(), "wood/planks/" + this.id.method_12832() + "_" + prefix), new class_2960(this.id.method_12836(), "wood/" + prefix + (String)suffix + "/" + this.id.method_12832())};
        Object found = null;
        for (class_2960 r : targets) {
            if (!reg.method_10250(r)) continue;
            found = reg.method_10223(r);
            break;
        }
        return (V)found;
    }

    @Nullable
    protected class_2248 findStrippedLog(String ... possibleNames) {
        for (String v : possibleNames) {
            class_2248 stripped;
            class_2248 b = this.getBlockOfThis(v);
            if (v == null || (stripped = (class_2248)class_1743.field_7898.get(b)) == null || stripped == b) continue;
            return stripped;
        }
        return this.findLogRelatedBlock("stripped", possibleNames);
    }

    @Nullable
    protected class_2248 findLogRelatedBlock(String prefix, String ... possibleSuffix) {
        for (String n : possibleSuffix) {
            class_2248 b = this.findWithPrefix(prefix, n);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @Nullable
    protected class_2248 findWithPrefix(String prefix, String suffix) {
        Optional o;
        Object prefix_ = prefix.isEmpty() ? "" : prefix + "_";
        class_2960 id = this.getId();
        String logNamespace = Utils.getID(this.log).method_12832();
        String path = id.method_12832();
        String namespace = id.method_12836();
        if (this.id.method_12836().matches("tfc|afc") && (o = class_7923.field_41175.method_17966(new class_2960(namespace, "wood/" + (String)prefix_ + suffix + "/" + path))).isPresent()) {
            return (class_2248)o.get();
        }
        HashSet<class_2960> targets = new HashSet<class_2960>();
        Collections.addAll(targets, new class_2960(namespace, path + "_" + (String)prefix_ + suffix), new class_2960(namespace, (String)prefix_ + path + "_" + suffix), new class_2960(namespace, logNamespace + "_" + (String)prefix_ + suffix), new class_2960(namespace, (String)prefix_ + logNamespace + "_" + suffix));
        if (path.endsWith(suffix)) {
            targets.add(new class_2960(namespace, (String)prefix_ + path));
        }
        return (class_2248)Utils.findFirstInRegistry(class_7923.field_41175, targets.toArray(new class_2960[0]));
    }

    static class_2960[] makeKnownIDConventions(class_2960 id, String ... suffixKeyword) {
        ArrayList<class_2960> resources = new ArrayList<class_2960>();
        for (String keyword : suffixKeyword) {
            String path = id.method_12832();
            String namespace = id.method_12836();
            resources.add(new class_2960(namespace, path + "_" + keyword));
            resources.add(new class_2960(namespace, keyword + "_" + path));
        }
        return resources.toArray(new class_2960[0]);
    }

    @Nullable
    static class_2248 findLog(class_2960 id) {
        class_2960[] tests = WoodType.makeKnownIDConventions(id, "log", "stem", "stalk", "hyphae");
        return (class_2248)Utils.findFirstInRegistry(class_7923.field_41175, tests);
    }

    @Nullable
    static class_2248 findPlanks(class_2960 id) {
        class_2960[] tests = WoodType.makeKnownIDConventions(id, "planks", "plank");
        return (class_2248)Utils.findFirstInRegistry(class_7923.field_41175, tests);
    }

    public class_4970.class_2251 copyProperties() {
        class_4970.class_2251 p = class_4970.class_2251.method_9637();
        p.method_31710(this.getColor());
        if (this.canBurn()) {
            p.method_50013();
        }
        p.method_9626(this.getSound());
        return p;
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<WoodType> {
        private Supplier<class_2248> planksFinder;
        private Supplier<class_2248> logFinder;

        public Finder(class_2960 id) {
            super(id, WoodTypeRegistry.INSTANCE);
            this.log(() -> WoodType.findLog(id));
            this.planks(() -> WoodType.findPlanks(id));
        }

        public Finder planks(Supplier<class_2248> planksFinder) {
            this.planksFinder = planksFinder;
            return this;
        }

        public Finder planks(class_2960 id) {
            return this.planks(() -> (class_2248)class_7923.field_41175.method_17966(id).orElseThrow(() -> new IllegalStateException("Failed to find planks block: " + String.valueOf(id))));
        }

        public Finder planks(String planksName) {
            return this.planks(Utils.idWithOptionalNamespace(planksName, this.id.method_12836()));
        }

        public Finder planksAffix(String prefix, String suffix) {
            return this.planks(prefix + this.id.method_12832() + suffix);
        }

        public Finder planksSuffix(String suffix) {
            return this.planks(this.id.method_12832() + suffix);
        }

        public Finder log(Supplier<class_2248> logFinder) {
            this.logFinder = logFinder;
            return this;
        }

        public Finder log(class_2960 id) {
            return this.log(() -> (class_2248)class_7923.field_41175.method_17966(id).orElseThrow(() -> new IllegalStateException("Failed to find log block: " + String.valueOf(id))));
        }

        public Finder log(String nameLog) {
            return this.log(Utils.idWithOptionalNamespace(nameLog, this.id.method_12836()));
        }

        public Finder logAffix(String prefix, String suffix) {
            return this.log(prefix + this.id.method_12832() + suffix);
        }

        public Finder logSuffix(String suffix) {
            return this.log(this.id.method_12832() + suffix);
        }

        @Override
        @ApiStatus.Internal
        public Optional<WoodType> get() {
            if (PlatHelper.isModLoaded(this.id.method_12836())) {
                try {
                    class_2248 plank = (class_2248)Preconditions.checkNotNull((Object)this.planksFinder.get(), (String)"Manual Finder - failed to find a plank block for {}", (Object)this.id);
                    class_2248 log = (class_2248)Preconditions.checkNotNull((Object)this.logFinder.get(), (String)"Manual Finder - failed to find a log block for {}", (Object)this.id);
                    WoodType woodType = new WoodType(this.id, plank, log);
                    this.childNames.forEach((key, value) -> {
                        try {
                            class_1935 obj = (class_1935)Preconditions.checkNotNull((Object)((class_1935)value.get()));
                            woodType.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            Moonlight.LOGGER.warn("Failed to find child for WoodType: {} - {}. Ignored! ERROR: {}", (Object)this.id, key, (Object)e.getMessage());
                        }
                    });
                    return Optional.of(woodType);
                }
                catch (Exception e) {
                    Moonlight.LOGGER.warn("Failed to find custom WoodType:  {} - ", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }

        @Deprecated(forRemoval=true)
        public Finder(class_2960 id, Supplier<class_2248> planks, Supplier<class_2248> log) {
            super(id, WoodTypeRegistry.INSTANCE);
            this.planksFinder = planks;
            this.logFinder = log;
        }

        @Deprecated(forRemoval=true)
        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(new class_2960(modId, woodTypeName), new class_2960(modId, planksName), new class_2960(modId, logName));
        }

        @Deprecated(forRemoval=true)
        public static Finder simple(class_2960 woodTypeName, class_2960 planksName, class_2960 logName) {
            return new Finder(woodTypeName, () -> (class_2248)class_7923.field_41175.method_10223(planksName), () -> (class_2248)class_7923.field_41175.method_10223(logName));
        }

        @Deprecated(forRemoval=true)
        public void addChild(String childType, String childName) {
            this.childBlock(childType, childName);
        }

        @Deprecated(forRemoval=true)
        public void addChild(String childType, class_2960 childName) {
            this.childBlock(childType, childName);
        }
    }
}

