/*
 * Decompiled with CFR 0.152.
 */
package io.github.eman7blue.numis_arch.block.entity;

import io.github.eman7blue.numis_arch.block.entity.NumisArchBlockEntityTypes;
import io.github.eman7blue.numis_arch.item.CoinItem;
import io.github.eman7blue.numis_arch.recipe.NumismaticGradingRecipe;
import io.github.eman7blue.numis_arch.screen.NumismaticDeskScreenHandler;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;

public class NumismaticDeskBlockEntity
extends class_2586
implements class_3908,
class_1263 {
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)13, (Object)class_1799.field_8037);
    protected static final int maxGradeTime = 20;
    protected int gradeTime;
    private final class_1863.class_7266<class_1263, NumismaticGradingRecipe> matchGetter;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            if (index == 0) {
                return NumismaticDeskBlockEntity.this.gradeTime;
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                NumismaticDeskBlockEntity.this.gradeTime = value;
            }
        }

        public int method_17389() {
            return 1;
        }
    };

    public NumismaticDeskBlockEntity(class_2338 pos, class_2680 state) {
        super(NumisArchBlockEntityTypes.NUMISMATIC_DESK, pos, state);
        this.matchGetter = class_1863.method_42302((class_3956)NumismaticGradingRecipe.Type.INSTANCE);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.numismatic_desk");
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        return this.inventory.isEmpty();
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > stack.method_7914()) {
            stack.method_7939(stack.method_7914());
        }
        if (slot == 0) {
            // empty if block
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new NumismaticDeskScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (stack.method_31573(CoinItem.COIN_ITEM_TAG)) {
            if (slot == 0) {
                return CoinItem.isUnknown(stack);
            }
            return !CoinItem.isUnknown(stack);
        }
        return false;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, NumismaticDeskBlockEntity blockEntity) {
        boolean isNotEmpty;
        boolean dirty = false;
        boolean bl = isNotEmpty = !((class_1799)blockEntity.inventory.get(0)).method_7960();
        if (isNotEmpty) {
            NumismaticGradingRecipe recipe;
            NumismaticGradingRecipe numismaticGradingRecipe = recipe = isNotEmpty ? (NumismaticGradingRecipe)blockEntity.matchGetter.method_42303((class_1263)blockEntity, world).orElse(null) : null;
            if (NumismaticDeskBlockEntity.canGrade(recipe, blockEntity.inventory, world.method_30349())) {
                ++blockEntity.gradeTime;
                if (blockEntity.gradeTime == 20) {
                    blockEntity.gradeTime = 0;
                    if (NumismaticDeskBlockEntity.canGrade(recipe, blockEntity.inventory, world.method_30349())) {
                        class_1799 itemStack = (class_1799)blockEntity.inventory.get(0);
                        class_1799 itemStackResult = recipe.method_8110(world.method_30349());
                        if (NumismaticDeskBlockEntity.addToOutput(world, itemStackResult, recipe, blockEntity)) {
                            itemStack.method_7934(1);
                        }
                    }
                }
                dirty = true;
            } else {
                blockEntity.gradeTime = 0;
            }
        }
        if (dirty) {
            NumismaticDeskBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    private static boolean canGrade(@Nullable class_1860<?> recipe, class_2371<class_1799> inventory, class_5455 registryManager) {
        if (((class_1799)inventory.get(0)).method_7960() || recipe == null) {
            return false;
        }
        class_1799 itemStack = recipe.method_8110(registryManager);
        if (itemStack.method_7960()) {
            return false;
        }
        for (int i = 1; i < inventory.size(); ++i) {
            if (!((class_1799)inventory.get(i)).method_7960()) continue;
            return true;
        }
        return false;
    }

    private static boolean addToOutput(class_1937 world, class_1799 itemStack, NumismaticGradingRecipe recipe, NumismaticDeskBlockEntity blockEntity) {
        class_2487 nbt = itemStack.method_7948();
        int max = recipe.getWeightSum();
        int rand = world.field_9229.method_43048(max);
        if (rand < recipe.getSuperb()) {
            nbt.method_10569("condition", 2);
        } else if (rand < recipe.getSuperb() + recipe.getFine()) {
            nbt.method_10569("condition", 1);
        } else {
            nbt.method_10569("condition", 0);
        }
        for (int i = 1; i < 13; ++i) {
            if (((class_1799)blockEntity.inventory.get(i)).method_7960()) {
                blockEntity.inventory.set(i, (Object)itemStack);
                return true;
            }
            if (!CoinItem.compareCondition(itemStack, (class_1799)blockEntity.inventory.get(i)) || !class_1799.method_31577((class_1799)itemStack, (class_1799)((class_1799)blockEntity.inventory.get(i))) || ((class_1799)blockEntity.inventory.get(i)).method_7947() >= ((class_1799)blockEntity.inventory.get(i)).method_7914()) continue;
            ((class_1799)blockEntity.inventory.get(i)).method_7933(1);
            return true;
        }
        return false;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
    }
}

