/*
 * Decompiled with CFR 0.152.
 */
package io.github.eman7blue.numis_arch.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.eman7blue.numis_arch.NumismaticArcheology;
import io.github.eman7blue.numis_arch.recipe.NumismaticGradingRecipe;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7923;

public class NumismaticGradingRecipeSerializer
implements class_1865<NumismaticGradingRecipe> {
    public static final NumismaticGradingRecipeSerializer INSTANCE = new NumismaticGradingRecipeSerializer();
    public static final class_2960 ID = NumismaticArcheology.id("numismatic_grading");

    public NumismaticGradingRecipe read(class_2960 id, JsonObject json) {
        NumismaticGradingRecipeJsonFormat recipeJson = (NumismaticGradingRecipeJsonFormat)new Gson().fromJson((JsonElement)json, NumismaticGradingRecipeJsonFormat.class);
        int poor = recipeJson.poor;
        int fine = recipeJson.fine;
        int superb = recipeJson.superb;
        if (recipeJson.output == null || recipeJson.input == null) {
            throw new JsonSyntaxException("Missing attributes for numismatic desk recipe!");
        }
        if (poor == 0 || fine == 0 || superb == 0) {
            NumismaticArcheology.LOGGER.warn("Missing one or more odds for numismatic desk recipe " + recipeJson.output + ", using default odds (6 poor; 13 fine; 1 superb) instead");
            poor = 6;
            fine = 13;
            superb = 1;
        }
        class_1856 input = class_1856.method_52177((JsonElement)recipeJson.input);
        class_1792 outputItem = (class_1792)class_7923.field_41178.method_17966(new class_2960(recipeJson.output)).orElseThrow(() -> new JsonSyntaxException("No such item " + recipeJson.output + " for numismatic desk recipe"));
        class_1799 output = new class_1799((class_1935)outputItem);
        return new NumismaticGradingRecipe(input, output, poor, fine, superb, id);
    }

    public NumismaticGradingRecipe read(class_2960 id, class_2540 buf) {
        class_1856 input = class_1856.method_8086((class_2540)buf);
        class_1799 output = buf.method_10819();
        int poor = buf.readInt();
        int fine = buf.readInt();
        int superb = buf.readInt();
        return new NumismaticGradingRecipe(input, output, poor, fine, superb, id);
    }

    public void write(class_2540 buf, NumismaticGradingRecipe recipe) {
        recipe.getInput().method_8088(buf);
        buf.method_10793(recipe.method_8110((class_5455)class_5455.field_40585));
        buf.writeInt(recipe.getPoor());
        buf.writeInt(recipe.getFine());
        buf.writeInt(recipe.getSuperb());
    }

    static class NumismaticGradingRecipeJsonFormat {
        JsonObject input;
        String output;
        int poor;
        int fine;
        int superb;

        NumismaticGradingRecipeJsonFormat() {
        }
    }
}

