/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.recipes;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1856;
import net.minecraft.class_2540;

public final class IngredientCodec {
    public static final Codec<class_1856> CODEC = Codec.PASSTHROUGH.comapFlatMap(IngredientCodec::decodeIngredient, IngredientCodec::encodeIngredient);
    public static final Codec<class_1856> NETWORK_CODEC = Codec.BYTE.listOf().flatXmap(IngredientCodec::decodeIngredientFromNetwork, IngredientCodec::encodeIngredientToNetwork);

    private IngredientCodec() throws UtilityClassException {
        throw new UtilityClassException();
    }

    private static DataResult<class_1856> decodeIngredient(Dynamic<?> dynamic) {
        Object object = dynamic.convert((DynamicOps)JsonOps.INSTANCE).getValue();
        if (object instanceof JsonElement) {
            JsonElement jsonElement = (JsonElement)object;
            return DataResult.success((Object)class_1856.method_52177((JsonElement)jsonElement));
        }
        return DataResult.error(() -> "Value was not an instance of JsonElement");
    }

    private static Dynamic<JsonElement> encodeIngredient(class_1856 ingredient) {
        return new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)ingredient.method_8089()).convert((DynamicOps)JsonOps.COMPRESSED);
    }

    private static DataResult<class_1856> decodeIngredientFromNetwork(List<Byte> data) {
        try {
            byte[] array = new byte[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                array[i] = data.get(i);
            }
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])array);
            return DataResult.success((Object)class_1856.method_8086((class_2540)new class_2540(buffer)));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to decode ingredient from network: " + e.getMessage());
        }
    }

    private static DataResult<List<Byte>> encodeIngredientToNetwork(class_1856 ingredient) {
        try {
            ByteBuf buffer = Unpooled.buffer();
            ingredient.method_8088(new class_2540(buffer));
            byte[] array = buffer.array();
            ArrayList<Byte> bytes = new ArrayList<Byte>(array.length);
            for (byte b : array) {
                bytes.add(b);
            }
            return DataResult.success(bytes);
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to encode ingredient to network: " + e.getMessage());
        }
    }
}

