/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.immediate.model;

import me.jellysquid.mods.sodium.client.render.immediate.model.ModelCuboid;
import me.jellysquid.mods.sodium.client.render.immediate.model.ModelPartData;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import org.apache.commons.lang3.ArrayUtils;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;

public class EntityRenderer {
    private static final int NUM_CUBE_VERTICES = 8;
    private static final int NUM_CUBE_FACES = 6;
    private static final int NUM_FACE_VERTICES = 4;
    private static final int VERTEX_X1_Y1_Z1 = 0;
    private static final int VERTEX_X2_Y1_Z1 = 1;
    private static final int VERTEX_X2_Y2_Z1 = 2;
    private static final int VERTEX_X1_Y2_Z1 = 3;
    private static final int VERTEX_X1_Y1_Z2 = 4;
    private static final int VERTEX_X2_Y1_Z2 = 5;
    private static final int VERTEX_X2_Y2_Z2 = 6;
    private static final int VERTEX_X1_Y2_Z2 = 7;
    private static final Matrix3f lastNormalMatrix;
    private static final int VERTEX_BUFFER_BYTES = 864;
    private static final Vector3f[] CUBE_CORNERS;
    private static final int[][] CUBE_VERTICES;
    private static final Vector3f[][] VERTEX_POSITIONS;
    private static final Vector3f[][] VERTEX_POSITIONS_MIRRORED;
    private static final Vector2f[][] VERTEX_TEXTURES;
    private static final Vector2f[][] VERTEX_TEXTURES_MIRRORED;
    private static final int[] CUBE_NORMALS;
    private static final int[] CUBE_NORMALS_MIRRORED;

    public static void render(class_4587 matrixStack, VertexBufferWriter writer, class_630 part, int light, int overlay, int color) {
        ModelPartData accessor = ModelPartData.from(part);
        if (!accessor.isVisible()) {
            return;
        }
        Object[] cuboids = accessor.getCuboids();
        Object[] children = accessor.getChildren();
        if (ArrayUtils.isEmpty((Object[])cuboids) && ArrayUtils.isEmpty((Object[])children)) {
            return;
        }
        matrixStack.method_22903();
        part.method_22703(matrixStack);
        if (!accessor.isHidden()) {
            EntityRenderer.renderCuboids(matrixStack.method_23760(), writer, (ModelCuboid[])cuboids, light, overlay, color);
        }
        EntityRenderer.renderChildren(matrixStack, writer, light, overlay, color, (class_630[])children);
        matrixStack.method_22909();
    }

    private static void renderChildren(class_4587 matrices, VertexBufferWriter writer, int light, int overlay, int color, class_630[] children) {
        for (class_630 part : children) {
            EntityRenderer.render(matrices, writer, part, light, overlay, color);
        }
    }

    public static void renderCuboids(class_4587.class_4665 matrices, VertexBufferWriter writer, ModelCuboid[] cuboids, int light, int overlay, int color) {
        for (ModelCuboid cuboid : cuboids) {
            EntityRenderer.renderCuboid(matrices, writer, cuboid, light, overlay, color);
        }
    }

    public static void renderCuboid(class_4587.class_4665 matrices, VertexBufferWriter writer, ModelCuboid cuboid, int light, int overlay, int color) {
        EntityRenderer.prepareNormalsIfChanged(matrices);
        EntityRenderer.prepareVertices(matrices, cuboid);
        try (MemoryStack stack = MemoryStack.stackPush();){
            long vertexBuffer = stack.nmalloc(16, 864);
            int vertexCount = EntityRenderer.emitQuads(vertexBuffer, cuboid, color, overlay, light);
            if (vertexCount > 0) {
                writer.push(stack, vertexBuffer, vertexCount, ModelVertex.FORMAT);
            }
        }
    }

    private static int emitQuads(long buffer, ModelCuboid cuboid, int color, int overlay, int light) {
        Vector3f[][] positions = cuboid.mirror ? VERTEX_POSITIONS_MIRRORED : VERTEX_POSITIONS;
        Vector2f[][] textures = cuboid.mirror ? VERTEX_TEXTURES_MIRRORED : VERTEX_TEXTURES;
        int[] normals = cuboid.mirror ? CUBE_NORMALS_MIRRORED : CUBE_NORMALS;
        int vertexCount = 0;
        long ptr = buffer;
        for (int quadIndex = 0; quadIndex < 6; ++quadIndex) {
            if (!cuboid.shouldDrawFace(quadIndex)) continue;
            EntityRenderer.emitVertex(ptr, positions[quadIndex][0], color, textures[quadIndex][0], overlay, light, normals[quadIndex]);
            EntityRenderer.emitVertex(ptr += 36L, positions[quadIndex][1], color, textures[quadIndex][1], overlay, light, normals[quadIndex]);
            EntityRenderer.emitVertex(ptr += 36L, positions[quadIndex][2], color, textures[quadIndex][2], overlay, light, normals[quadIndex]);
            EntityRenderer.emitVertex(ptr += 36L, positions[quadIndex][3], color, textures[quadIndex][3], overlay, light, normals[quadIndex]);
            ptr += 36L;
            vertexCount += 4;
        }
        return vertexCount;
    }

    private static void emitVertex(long ptr, Vector3f pos, int color, Vector2f tex, int overlay, int light, int normal) {
        ModelVertex.write(ptr, pos.x, pos.y, pos.z, color, tex.x, tex.y, overlay, light, normal);
    }

    private static void prepareVertices(class_4587.class_4665 matrices, ModelCuboid cuboid) {
        EntityRenderer.buildVertexPosition(CUBE_CORNERS[0], cuboid.x1, cuboid.y1, cuboid.z1, matrices.method_23761());
        EntityRenderer.buildVertexPosition(CUBE_CORNERS[1], cuboid.x2, cuboid.y1, cuboid.z1, matrices.method_23761());
        EntityRenderer.buildVertexPosition(CUBE_CORNERS[2], cuboid.x2, cuboid.y2, cuboid.z1, matrices.method_23761());
        EntityRenderer.buildVertexPosition(CUBE_CORNERS[3], cuboid.x1, cuboid.y2, cuboid.z1, matrices.method_23761());
        EntityRenderer.buildVertexPosition(CUBE_CORNERS[4], cuboid.x1, cuboid.y1, cuboid.z2, matrices.method_23761());
        EntityRenderer.buildVertexPosition(CUBE_CORNERS[5], cuboid.x2, cuboid.y1, cuboid.z2, matrices.method_23761());
        EntityRenderer.buildVertexPosition(CUBE_CORNERS[6], cuboid.x2, cuboid.y2, cuboid.z2, matrices.method_23761());
        EntityRenderer.buildVertexPosition(CUBE_CORNERS[7], cuboid.x1, cuboid.y2, cuboid.z2, matrices.method_23761());
        EntityRenderer.buildVertexTexCoord(VERTEX_TEXTURES[0], cuboid.u1, cuboid.v0, cuboid.u2, cuboid.v1);
        EntityRenderer.buildVertexTexCoord(VERTEX_TEXTURES[1], cuboid.u2, cuboid.v1, cuboid.u3, cuboid.v0);
        EntityRenderer.buildVertexTexCoord(VERTEX_TEXTURES[3], cuboid.u1, cuboid.v1, cuboid.u2, cuboid.v2);
        EntityRenderer.buildVertexTexCoord(VERTEX_TEXTURES[5], cuboid.u4, cuboid.v1, cuboid.u5, cuboid.v2);
        EntityRenderer.buildVertexTexCoord(VERTEX_TEXTURES[2], cuboid.u2, cuboid.v1, cuboid.u4, cuboid.v2);
        EntityRenderer.buildVertexTexCoord(VERTEX_TEXTURES[4], cuboid.u0, cuboid.v1, cuboid.u1, cuboid.v2);
    }

    public static void prepareNormalsIfChanged(class_4587.class_4665 matrices) {
        if (!matrices.method_23762().equals((Object)lastNormalMatrix)) {
            lastNormalMatrix.set((Matrix3fc)matrices.method_23762());
            EntityRenderer.CUBE_NORMALS[0] = MatrixHelper.transformNormal(matrices.method_23762(), true, class_2350.field_11033);
            EntityRenderer.CUBE_NORMALS[1] = MatrixHelper.transformNormal(matrices.method_23762(), true, class_2350.field_11036);
            EntityRenderer.CUBE_NORMALS[3] = MatrixHelper.transformNormal(matrices.method_23762(), true, class_2350.field_11043);
            EntityRenderer.CUBE_NORMALS[5] = MatrixHelper.transformNormal(matrices.method_23762(), true, class_2350.field_11035);
            EntityRenderer.CUBE_NORMALS[4] = MatrixHelper.transformNormal(matrices.method_23762(), true, class_2350.field_11039);
            EntityRenderer.CUBE_NORMALS[2] = MatrixHelper.transformNormal(matrices.method_23762(), true, class_2350.field_11034);
            EntityRenderer.CUBE_NORMALS_MIRRORED[0] = CUBE_NORMALS[0];
            EntityRenderer.CUBE_NORMALS_MIRRORED[1] = CUBE_NORMALS[1];
            EntityRenderer.CUBE_NORMALS_MIRRORED[3] = CUBE_NORMALS[3];
            EntityRenderer.CUBE_NORMALS_MIRRORED[5] = CUBE_NORMALS[5];
            EntityRenderer.CUBE_NORMALS_MIRRORED[4] = CUBE_NORMALS[2];
            EntityRenderer.CUBE_NORMALS_MIRRORED[2] = CUBE_NORMALS[4];
        }
    }

    private static void buildVertexPosition(Vector3f vector, float x, float y, float z, Matrix4f matrix) {
        vector.x = MatrixHelper.transformPositionX(matrix, x, y, z);
        vector.y = MatrixHelper.transformPositionY(matrix, x, y, z);
        vector.z = MatrixHelper.transformPositionZ(matrix, x, y, z);
    }

    private static void buildVertexTexCoord(Vector2f[] uvs, float u1, float v1, float u2, float v2) {
        uvs[0].set(u2, v1);
        uvs[1].set(u1, v1);
        uvs[2].set(u1, v2);
        uvs[3].set(u2, v2);
    }

    static {
        int vertexIndex;
        int quadIndex;
        lastNormalMatrix = new Matrix3f();
        CUBE_CORNERS = new Vector3f[8];
        CUBE_VERTICES = new int[6][];
        VERTEX_POSITIONS = new Vector3f[6][4];
        VERTEX_POSITIONS_MIRRORED = new Vector3f[6][4];
        VERTEX_TEXTURES = new Vector2f[6][4];
        VERTEX_TEXTURES_MIRRORED = new Vector2f[6][4];
        CUBE_NORMALS = new int[6];
        CUBE_NORMALS_MIRRORED = new int[6];
        EntityRenderer.CUBE_VERTICES[0] = new int[]{5, 4, 0, 1};
        EntityRenderer.CUBE_VERTICES[1] = new int[]{2, 3, 7, 6};
        EntityRenderer.CUBE_VERTICES[3] = new int[]{1, 0, 3, 2};
        EntityRenderer.CUBE_VERTICES[5] = new int[]{4, 5, 6, 7};
        EntityRenderer.CUBE_VERTICES[2] = new int[]{5, 1, 2, 6};
        EntityRenderer.CUBE_VERTICES[4] = new int[]{0, 4, 7, 3};
        for (int cornerIndex = 0; cornerIndex < 8; ++cornerIndex) {
            EntityRenderer.CUBE_CORNERS[cornerIndex] = new Vector3f();
        }
        for (quadIndex = 0; quadIndex < 6; ++quadIndex) {
            for (vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                EntityRenderer.VERTEX_TEXTURES[quadIndex][vertexIndex] = new Vector2f();
                EntityRenderer.VERTEX_POSITIONS[quadIndex][vertexIndex] = CUBE_CORNERS[CUBE_VERTICES[quadIndex][vertexIndex]];
            }
        }
        for (quadIndex = 0; quadIndex < 6; ++quadIndex) {
            for (vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                EntityRenderer.VERTEX_TEXTURES_MIRRORED[quadIndex][vertexIndex] = VERTEX_TEXTURES[quadIndex][3 - vertexIndex];
                EntityRenderer.VERTEX_POSITIONS_MIRRORED[quadIndex][vertexIndex] = VERTEX_POSITIONS[quadIndex][3 - vertexIndex];
            }
        }
    }
}

