/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.AlternativeBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.GenericProjectileBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.SlingshotBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class CannonBlock
extends class_2318
implements class_2343,
ILightable,
IRotatable {
    private static final Map<class_1792, IFireItemBehavior> FIRE_BEHAVIORS = new Object2ObjectOpenHashMap();
    private static final IFireItemBehavior DEFAULT = new AlternativeBehavior(new GenericProjectileBehavior(), new SlingshotBehavior());
    protected static final class_265 SHAPE_DOWN = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final class_265 SHAPE_UP = class_2248.method_9541((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SHAPE_SOUTH = class_2248.method_9541((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SHAPE_NORTH = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final class_265 SHAPE_EAST = class_2248.method_9541((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SHAPE_WEST = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final class_2746 POWERED = class_2741.field_12484;

    public CannonBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public static void clearBehaviors() {
        FIRE_BEHAVIORS.clear();
    }

    public static void registerBehavior(class_1935 pItem, IFireItemBehavior pBehavior) {
        FIRE_BEHAVIORS.put(pItem.method_8389(), pBehavior);
    }

    public static IFireItemBehavior getCannonBehavior(class_1935 item) {
        return FIRE_BEHAVIORS.getOrDefault(item, DEFAULT);
    }

    public void method_9568(class_1799 itemStack, @Nullable class_1922 blockGetter, List<class_2561> list, class_1836 tooltipFlag) {
        super.method_9568(itemStack, blockGetter, list, tooltipFlag);
        if (!MiscUtils.showsHints(blockGetter, tooltipFlag)) {
            return;
        }
        list.add((class_2561)class_2561.method_43471((String)"message.supplementaries.cannon").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
    }

    @Nullable
    public class_3908 method_17454(class_2680 state, class_1937 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)class_25862;
            return tile;
        }
        return null;
    }

    public boolean method_22358(class_2680 state, class_3611 fluid) {
        return false;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{field_10927, POWERED});
    }

    public boolean method_9579(class_2680 state, class_1922 level, class_2338 pos) {
        return state.method_26227().method_15769();
    }

    public float method_9575(class_2680 state, class_1922 level, class_2338 pos) {
        return 1.0f;
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)context.method_8038())).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(context.method_8045().method_49803(context.method_8037())));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657((class_2769)field_10927, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)field_10927)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state.method_26186(mirrorIn.method_10345((class_2350)state.method_11654((class_2769)field_10927)));
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2586 class_25862;
        super.method_9567(level, pos, state, placer, stack);
        if (placer != null && (class_25862 = level.method_8321(pos)) instanceof CannonBlockTile) {
            CannonBlockTile cannon = (CannonBlockTile)class_25862;
            class_2350 dir = class_2350.method_10159((class_1297)placer)[0];
            class_2350 myDir = ((class_2350)state.method_11654((class_2769)field_10927)).method_10153();
            if (dir.method_10166() == class_2350.class_2351.field_11052) {
                float pitch = dir == class_2350.field_11036 ? -90.0f : 90.0f;
                cannon.setRestrainedPitch(myDir.method_10153() == dir ? pitch + 180.0f : pitch);
            } else {
                float yaw = dir.method_10144();
                cannon.setRestrainedYaw(myDir.method_10153() == dir ? yaw + 180.0f : yaw);
            }
        }
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        boolean wasPowered;
        if (!level.field_9236 && (wasPowered = ((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) != level.method_49803(pos)) {
            class_2586 class_25862;
            level.method_8652(pos, (class_2680)state.method_28493((class_2769)POWERED), 2);
            if (!wasPowered && (class_25862 = level.method_8321(pos)) instanceof CannonBlockTile) {
                CannonBlockTile tile = (CannonBlockTile)class_25862;
                tile.ignite(null);
            }
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CannonBlockTile(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 pLevel, class_2680 pState, class_2591<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.CANNON_TILE.get(), CannonBlockTile::tick);
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1269 litUpAction = this.interactWithPlayer(state, level, pos, player, hand);
        if (litUpAction != class_1269.field_5811) {
            return litUpAction;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)class_25862;
            if (player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                tile.tryOpeningEditGui(sp, pos, player.method_5998(hand));
            }
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return super.method_9534(state, level, pos, player, hand, hit);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (state.method_26204() != newState.method_26204()) {
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof CannonBlockTile) {
                CannonBlockTile tile = (CannonBlockTile)class_25862;
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)tile);
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, isMoving);
        }
    }

    public boolean isLitUp(class_2680 state, class_1922 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)class_25862;
            return tile.isFiring();
        }
        return false;
    }

    public boolean lightUp(@Nullable class_1297 player, class_2680 state, class_2338 pos, class_1936 world, ILightable.FireSourceType fireSourceType) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)class_25862;
            if (tile.readyToFire()) {
                if (!world.method_8608()) {
                    tile.ignite(player);
                    this.playLightUpSound(world, pos, fireSourceType);
                }
                world.method_33596(player, class_5712.field_28733, pos);
                return true;
            }
            return false;
        }
        return false;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_265 method_9571(class_2680 state, class_1922 level, class_2338 pos) {
        return switch (((class_2350)state.method_11654((class_2769)field_10927)).method_10153()) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11036 -> SHAPE_UP;
            case class_2350.field_11033 -> SHAPE_DOWN;
            case class_2350.field_11043 -> SHAPE_NORTH;
            case class_2350.field_11035 -> SHAPE_SOUTH;
            case class_2350.field_11039 -> SHAPE_WEST;
            case class_2350.field_11034 -> SHAPE_EAST;
        };
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return super.method_9530(state, level, pos, context);
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        if (context instanceof class_3727) {
            class_3727 ec = (class_3727)context;
            class_1297 class_12972 = ec.method_32480();
            if (class_12972 instanceof class_1676) {
                class_1676 p = (class_1676)class_12972;
                if (p.field_6012 < 10) {
                    return class_259.method_1073();
                }
            }
            if (ec.method_32480() != null) {
                return super.method_9549(state, level, pos, context);
            }
        }
        return class_259.method_1073();
    }

    public class_265 method_26159(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return switch ((class_2350)state.method_11654((class_2769)field_10927)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11036 -> SHAPE_UP;
            case class_2350.field_11033 -> SHAPE_DOWN;
            case class_2350.field_11043 -> SHAPE_NORTH;
            case class_2350.field_11035 -> SHAPE_SOUTH;
            case class_2350.field_11039 -> SHAPE_WEST;
            case class_2350.field_11034 -> SHAPE_EAST;
        };
    }

    public boolean method_9498(class_2680 blockState) {
        return true;
    }

    public int method_9572(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        return class_1703.method_7608((class_2586)level.method_8321(blockPos));
    }

    public boolean method_9592(class_2680 state, class_1937 level, class_2338 pos, int id, int param) {
        if (id > 1) {
            return false;
        }
        if (!level.field_9236) {
            return true;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)class_25862;
            float yaw = tile.getYaw();
            float pitch = tile.getPitch();
            class_4587 poseStack = new class_4587();
            poseStack.method_46416((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f + 0.0625f, (float)pos.method_10260() + 0.5f);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-yaw));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(pitch));
            poseStack.method_22904(0.0, 0.0, -1.4);
            if (id == 1) {
                this.playFiringEffects(pos, level, poseStack, pitch, yaw, tile.getPowerLevel());
            } else {
                CannonBlock.playIgniteEffects(pos, level, poseStack);
            }
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static void playIgniteEffects(class_2338 pos, class_1937 level, class_4587 poseStack) {
        Vector4f p = poseStack.method_23760().method_23761().transform(new Vector4f(0.0f, 0.0f, 1.75f, 1.0f));
        level.method_8406((class_2394)class_2398.field_11240, (double)p.x, (double)p.y, (double)p.z, 0.0, 0.0, 0.0);
        level.method_45446(pos, ModSounds.CANNON_IGNITE.get(), class_3419.field_15245, 0.6f, 1.2f + level.method_8409().method_43057() * 0.2f, false);
    }

    @Environment(value=EnvType.CLIENT)
    private void playFiringEffects(class_2338 pos, class_1937 level, class_4587 poseStack, float pitch, float yaw, int power) {
        level.method_8406((class_2394)ModParticles.CANNON_FIRE_PARTICLE.get(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (double)(pitch * ((float)Math.PI / 180)), (double)(-yaw * ((float)Math.PI / 180)), 0.0);
        class_5819 ran = level.field_9229;
        this.spawnDustRing(level, poseStack);
        this.spawnSmokeTrail(level, poseStack, ran);
        float soundPitch = 1.3f - (float)power * 0.1f;
        float soundVolume = 2.0f + (float)power * 0.6f;
        level.method_45446(pos, ModSounds.CANNON_FIRE.get(), class_3419.field_15245, soundVolume, soundPitch, false);
    }

    @Environment(value=EnvType.CLIENT)
    private void spawnSmokeTrail(class_1937 level, class_4587 poseStack, class_5819 ran) {
        int smokeCount = 40;
        for (int i = 0; i < smokeCount; ++i) {
            poseStack.method_22903();
            Vector4f speed = poseStack.method_23760().method_23761().transform(new Vector4f(0.0f, 0.0f, -MthUtils.nextWeighted((class_5819)ran, (float)0.5f, (float)1.0f, (float)0.06f), 0.0f));
            float aperture = 0.5f;
            poseStack.method_46416(-aperture / 2.0f + ran.method_43057() * aperture, -aperture / 2.0f + ran.method_43057() * aperture, 0.0f);
            Vector4f p = poseStack.method_23760().method_23761().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
            level.method_8406((class_2394)class_2398.field_11251, (double)p.x, (double)p.y, (double)p.z, (double)speed.x, (double)speed.y, (double)speed.z);
            poseStack.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void spawnDustRing(class_1937 level, class_4587 poseStack) {
        poseStack.method_22903();
        Vector4f p = poseStack.method_23760().method_23761().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
        int dustCount = 16;
        for (int i = 0; i < dustCount; ++i) {
            poseStack.method_22903();
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(380.0f * (float)i / (float)dustCount));
            Vector4f speed = poseStack.method_23760().method_23761().transform(new Vector4f(0.0f, 0.0f, 0.05f, 0.0f));
            level.method_8406((class_2394)ModParticles.BOMB_SMOKE_PARTICLE.get(), (double)p.x, (double)p.y, (double)p.z, (double)speed.x, (double)speed.y, (double)speed.z);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    public Optional<class_2680> getRotatedState(class_2680 state, class_1936 levelAccessor, class_2338 blockPos, class_2470 rotation, class_2350 axis, @Nullable class_243 hit) {
        boolean ccw = rotation == class_2470.field_11465;
        return BlockUtil.getRotatedDirectionalBlock(state, axis, ccw).or(() -> Optional.of(state));
    }

    public void onRotated(class_2680 newState, class_2680 oldState, class_1936 world, class_2338 pos, class_2470 rotation, class_2350 axis, @Nullable class_243 hit) {
        class_2586 class_25862;
        if (axis.method_10166() == ((class_2350)newState.method_11654((class_2769)field_10927)).method_10166() && (class_25862 = world.method_8321(pos)) instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)class_25862;
            float angle = rotation.method_10502(0, 4) * -90;
            Vector3f currentDir = class_243.method_1030((float)tile.getPitch(), (float)tile.getYaw()).method_46409();
            Quaternionf q = new Quaternionf().rotateAxis(angle * ((float)Math.PI / 180), (Vector3fc)axis.method_23955());
            currentDir.rotate((Quaternionfc)q);
            class_243 newDir = new class_243(currentDir);
            tile.setRestrainedYaw((float)MthUtils.getYaw((class_243)newDir));
            tile.setRestrainedPitch((float)MthUtils.getPitch((class_243)newDir));
            tile.method_5431();
            tile.method_10997().method_8413(pos, oldState, newState, 3);
        }
    }
}

