/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.misc.RegistryAccessJsonReloadListener;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.faucet.APIFluidTankInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.BeehiveInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.BrewingStandInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.ConcreteInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.ContainerItemInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.DataFluidInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.DataItemInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FiniteFluidInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FullBucketCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.LiquidBlockInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.MudInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.PowderSnowCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SappyLogInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SoftFluidProviderInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SoftFluidTankInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SpongeInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.WaterCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.XPDroppingInteraction;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.fake_level.BlockTestLevel;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class FaucetBehaviorsManager
extends RegistryAccessJsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final FaucetBehaviorsManager RELOAD_INSTANCE = new FaucetBehaviorsManager();
    private final Set<Object> dataInteractions = new HashSet<Object>();
    private final Set<Runnable> listeners = new HashSet<Runnable>();
    private static final Codec<Either<DataItemInteraction, DataFluidInteraction>> CODEC = Codec.either(DataItemInteraction.CODEC, DataFluidInteraction.CODEC);

    public FaucetBehaviorsManager() {
        super(GSON, "faucet_interactions");
    }

    public static void addRegisterFaucetInteraction(Runnable listener) {
        FaucetBehaviorsManager.RELOAD_INSTANCE.listeners.add(listener);
    }

    public void parse(Map<class_2960, JsonElement> map, class_5455 registryAccess) {
        FaucetBlockTile.clearBehaviors();
        this.dataInteractions.clear();
        map.forEach((key, json) -> {
            try {
                DataResult result = CODEC.parse((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess), json);
                Either d = (Either)result.getOrThrow(false, e -> Supplementaries.LOGGER.error("Failed to fluid interaction: {}", e));
                Optional l = d.left();
                Object o = l.isPresent() ? l.get() : d.right().get();
                this.dataInteractions.add(o);
            }
            catch (Exception e2) {
                Supplementaries.LOGGER.error("Failed to parse JSON object for faucet interaction {}", key);
            }
        });
        if (!this.dataInteractions.isEmpty()) {
            Supplementaries.LOGGER.info("Loaded  {} custom faucet interactions", (Object)this.dataInteractions.size());
        }
    }

    public void onLevelLoad(class_3218 level) {
        FaucetBlockTile.clearBehaviors();
        this.dataInteractions.forEach(FaucetBlockTile::registerInteraction);
        FaucetBlockTile.registerInteraction(new SoftFluidProviderInteraction());
        FaucetBlockTile.registerInteraction(new WaterCauldronInteraction());
        FaucetBlockTile.registerInteraction(new FullBucketCauldronInteraction(class_2246.field_27098.method_9564(), class_1802.field_8187.method_7854()));
        FaucetBlockTile.registerInteraction(new PowderSnowCauldronInteraction());
        FaucetBlockTile.registerInteraction(new BeehiveInteraction());
        FaucetBlockTile.registerInteraction(new SoftFluidTankInteraction());
        FaucetBlockTile.registerInteraction(new APIFluidTankInteraction());
        FaucetBlockTile.registerInteraction(new BrewingStandInteraction());
        FaucetBlockTile.registerInteraction(new FiniteFluidInteraction());
        FaucetBlockTile.registerInteraction(new LiquidBlockInteraction());
        FaucetBlockTile.registerInteraction(new SpongeInteraction());
        FaucetBlockTile.registerInteraction(new XPDroppingInteraction());
        FaucetBlockTile.registerInteraction(new ConcreteInteraction());
        FaucetBlockTile.registerInteraction(new MudInteraction());
        FaucetBlockTile.registerInteraction(new ContainerItemInteraction());
        if (CompatHandler.AUTUMNITY) {
            FaucetBlockTile.registerInteraction(new SappyLogInteraction());
        }
        BlockTestLevel testLevel = BlockTestLevel.get(level);
        class_1657 player = FakePlayerManager.getDefault((class_1937)testLevel);
        class_1268 hand = class_1268.field_5808;
        class_2680 emptyCauldron = class_2246.field_10593.method_9564();
        for (Map.Entry e : class_5620.field_27775.entrySet()) {
            class_1792 i = (class_1792)e.getKey();
            class_5620 interaction = (class_5620)e.getValue();
            if (Utils.getID((class_1792)i).method_12836().equals("minecraft")) continue;
            testLevel.setup();
            class_1799 fullBucket = i.method_7854();
            class_1799 fullBucketCopy = fullBucket.method_7972();
            player.method_6122(hand, fullBucket);
            interaction.interact(emptyCauldron, (class_1937)testLevel, class_2338.field_10980, player, hand, fullBucket);
            class_2680 fullCauldron = testLevel.blockState;
            if (fullCauldron == null || fullCauldron.method_28498((class_2769)class_5556.field_27206) && PlatHelper.getPlatform().isForge()) continue;
            FaucetBlockTile.registerInteraction(new FullBucketCauldronInteraction(fullCauldron, fullBucketCopy));
        }
        testLevel.invalidate();
        this.listeners.forEach(Runnable::run);
    }

    @Deprecated(forRemoval=true)
    public static void prepareToTransferBottle(SoftFluidTank tempFluidHolder, SoftFluid softFluid, @Nullable class_2487 tag) {
    }
}

