/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.function.Predicate;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.items.SelectableContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.fabric.QuiverItemImpl;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1744;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuiverItem
extends SelectableContainerItem<Data>
implements class_1768 {
    public QuiverItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public Data getData(class_1799 stack) {
        return QuiverItem.getQuiverData(stack);
    }

    @Override
    public int getMaxSlots() {
        return CommonConfigs.Tools.QUIVER_SLOTS.get();
    }

    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Data getQuiverData(class_1799 stack) {
        return QuiverItemImpl.getQuiverData(stack);
    }

    @NotNull
    public static SlotReference findActiveQuiverSlot(class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            SlotReference curioQuiver = CompatHandler.getQuiverFromModsSlots(player);
            if (!curioQuiver.isEmpty()) {
                return curioQuiver;
            }
            if (CommonConfigs.Tools.QUIVER_CURIO_ONLY.get().booleanValue()) {
                return SlotReference.EMPTY;
            }
        } else if (entity instanceof IQuiverEntity) {
            IQuiverEntity e = (IQuiverEntity)entity;
            return SlotReference.quiver(e);
        }
        return SuppPlatformStuff.getFirstInInventory(entity, i -> i.method_7909() instanceof QuiverItem);
    }

    public static class_1799 findActiveQuiver(class_1309 entity) {
        return QuiverItem.findActiveQuiverSlot(entity).get(entity);
    }

    public static boolean canAcceptItem(class_1799 toInsert) {
        return toInsert.method_7909() instanceof class_1744 && !toInsert.method_31573(ModTags.QUIVER_BLACKLIST);
    }

    public static interface Data
    extends SelectableContainerItem.AbstractData {
        @Override
        default public boolean canAcceptItem(class_1799 toInsert) {
            return QuiverItem.canAcceptItem(toInsert);
        }

        @Override
        default public class_1799 getSelected() {
            return this.getSelected(null);
        }

        default public class_1799 getSelected(@Nullable Predicate<class_1799> supporterArrows) {
            List<class_1799> content = this.getContentView();
            int selected = this.getSelectedSlot();
            if (supporterArrows == null) {
                return content.get(selected);
            }
            int size = content.size();
            for (int i = 0; i < size; ++i) {
                class_1799 s = content.get((i + selected) % size);
                if (!supporterArrows.test(s)) continue;
                return s;
            }
            return class_1799.field_8037;
        }
    }
}

