/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.commands.manage;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.core.RestoreableFile;
import net.szum123321.textile_backup.core.restore.RestoreHelper;

public class ListBackupsCommand {
    private static final TextileLogger log = new TextileLogger("Textile Backup");

    public static LiteralArgumentBuilder<class_2168> register() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(ctx -> {
            StringBuilder builder = new StringBuilder();
            LinkedList<RestoreableFile> backups = RestoreHelper.getAvailableBackups(((class_2168)ctx.getSource()).method_9211());
            if (backups.size() == 0) {
                builder.append("There a no backups available for this world.");
            } else if (backups.size() == 1) {
                builder.append("There is only one backup available: ");
                builder.append(backups.get(0).toString());
            } else {
                backups.sort(null);
                Iterator iterator = backups.iterator();
                builder.append("Available backups:\n");
                builder.append(iterator.next());
                while (iterator.hasNext()) {
                    builder.append(",\n");
                    builder.append(((RestoreableFile)iterator.next()).toString());
                }
            }
            log.sendInfo((class_2168)ctx.getSource(), builder.toString(), new Object[0]);
            return 1;
        });
    }
}

