/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.commands.restore;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.commands.CommandExceptions;
import net.szum123321.textile_backup.commands.FileSuggestionProvider;
import net.szum123321.textile_backup.core.RestoreableFile;
import net.szum123321.textile_backup.core.restore.RestoreContext;
import net.szum123321.textile_backup.core.restore.RestoreHelper;

public class RestoreBackupCommand {
    private static final TextileLogger log = new TextileLogger("Textile Backup");

    public static LiteralArgumentBuilder<class_2168> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"restore").then(class_2170.method_9244((String)"file", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)FileSuggestionProvider.Instance()).executes(ctx -> RestoreBackupCommand.execute(StringArgumentType.getString((CommandContext)ctx, (String)"file"), null, (class_2168)ctx.getSource())))).then(class_2170.method_9244((String)"file", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)FileSuggestionProvider.Instance()).then(class_2170.method_9244((String)"comment", (ArgumentType)StringArgumentType.word()).executes(ctx -> RestoreBackupCommand.execute(StringArgumentType.getString((CommandContext)ctx, (String)"file"), StringArgumentType.getString((CommandContext)ctx, (String)"comment"), (class_2168)ctx.getSource()))))).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            log.sendInfo(source, "To restore given backup you have to provide exact creation time in format:", new Object[0]);
            log.sendInfo(source, "[YEAR]-[MONTH]-[DAY]_[HOUR].[MINUTE].[SECOND]", new Object[0]);
            log.sendInfo(source, "Example: /backup restore 2020-08-05_10.58.33", new Object[0]);
            log.sendInfo(source, "You may also type '/backup restore latest' to restore the freshest backup", new Object[0]);
            return 1;
        });
    }

    private static int execute(String file, @Nullable String comment, class_2168 source) throws CommandSyntaxException {
        LocalDateTime dateTime;
        Optional<RestoreableFile> backupFile;
        if (Globals.INSTANCE.getAwaitThread().filter(Thread::isAlive).isPresent()) {
            log.sendInfo(source, "Someone has already started another restoration.", new Object[0]);
            return -1;
        }
        if (Objects.equals(file, "latest")) {
            backupFile = RestoreHelper.getLatestAndLockIfPresent(source.method_9211());
            dateTime = backupFile.map(RestoreableFile::getCreationTime).orElse(LocalDateTime.now());
        } else {
            try {
                dateTime = LocalDateTime.from(Globals.defaultDateTimeFormatter.parse(file));
            }
            catch (DateTimeParseException e) {
                throw CommandExceptions.DATE_TIME_PARSE_COMMAND_EXCEPTION_TYPE.create((Object)e);
            }
            backupFile = RestoreHelper.findFileAndLockIfPresent(dateTime, source.method_9211());
        }
        if (backupFile.isEmpty()) {
            log.sendInfo(source, "No file created on {} was found!", dateTime.format(Globals.defaultDateTimeFormatter));
            return -1;
        }
        log.info("Found file to restore {}", backupFile.get().getFile().getFileName().toString());
        Globals.INSTANCE.setAwaitThread(RestoreHelper.create(RestoreContext.Builder.newRestoreContextBuilder().setCommandSource(source).setFile(backupFile.get()).setComment(comment).build()));
        Globals.INSTANCE.getAwaitThread().get().start();
        return 1;
    }
}

