/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.core.RestoreableFile;
import net.szum123321.textile_backup.core.Utilities;

public class Cleanup
implements Callable<Integer> {
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final ConfigHelper config = ConfigHelper.INSTANCE;
    private final class_2168 ctx;
    private final String worldName;

    public Cleanup(class_2168 ctx, String worldName) {
        this.ctx = ctx;
        this.worldName = worldName;
    }

    @Override
    public Integer call() {
        Path root = Utilities.getBackupRootPath(this.worldName);
        int deletedFiles = 0;
        if (!Files.isDirectory(root, new LinkOption[0]) || !Files.exists(root, new LinkOption[0]) || this.isEmpty(root)) {
            return 0;
        }
        if (Cleanup.config.get().maxAge > 0L) {
            long now = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
            deletedFiles = (int)((long)deletedFiles + RestoreableFile.applyOnFiles(root, 0L, e -> log.error("An exception occurred while trying to delete old files!", e), stream -> stream.filter(f -> now - f.getCreationTime().toEpochSecond(ZoneOffset.UTC) > Cleanup.config.get().maxAge).filter(f -> this.deleteFile(f.getFile(), this.ctx)).count()));
        }
        int noToKeep = Cleanup.config.get().backupsToKeep > 0 ? Cleanup.config.get().backupsToKeep : Integer.MAX_VALUE;
        long maxSize = Cleanup.config.get().maxSize > 0L ? Cleanup.config.get().maxSize * 1024L : Long.MAX_VALUE;
        long[] counts = this.count(root);
        long n = counts[0];
        long size = counts[1];
        Iterator it = RestoreableFile.applyOnFiles(root, null, e -> log.error("An exception occurred while trying to delete old files!", e), s -> s.sorted().toList().iterator());
        if (Objects.isNull(it)) {
            return deletedFiles;
        }
        while (it.hasNext() && (n > (long)noToKeep || size > maxSize)) {
            long x;
            Path f = ((RestoreableFile)it.next()).getFile();
            try {
                x = Files.size(f);
            }
            catch (IOException e2) {
                size = 0L;
                continue;
            }
            if (!this.deleteFile(f, this.ctx)) continue;
            size -= x;
            --n;
            ++deletedFiles;
        }
        return deletedFiles;
    }

    private long[] count(Path root) {
        long n = 0L;
        long size = 0L;
        try (Stream<Path> stream = Files.list(root);){
            Iterator it = stream.flatMap(f -> RestoreableFile.build(f).stream()).iterator();
            while (it.hasNext()) {
                RestoreableFile f2 = (RestoreableFile)it.next();
                try {
                    size += Files.size(f2.getFile());
                }
                catch (IOException e) {
                    log.error("Couldn't get size of " + f2.getFile(), new Object[]{e});
                    continue;
                }
                ++n;
            }
        }
        catch (IOException e) {
            log.error("Error while counting files!", new Object[]{e});
        }
        return new long[]{n, size};
    }

    private boolean isEmpty(Path root) {
        if (!Files.isDirectory(root, new LinkOption[0])) {
            return false;
        }
        return RestoreableFile.applyOnFiles(root, false, e -> {}, s -> s.findFirst().isEmpty());
    }

    private boolean deleteFile(Path f, class_2168 ctx) {
        if (Globals.INSTANCE.getLockedFile().filter(p -> p == f).isPresent()) {
            return false;
        }
        try {
            Files.delete(f);
            log.sendInfoAL(ctx, "Deleted: {}", f);
        }
        catch (IOException e) {
            if (Utilities.wasSentByPlayer(ctx)) {
                log.sendError(ctx, "Something went wrong while deleting: {}.", f);
            }
            log.error("Something went wrong while deleting: {}.", f, e);
            return false;
        }
        return true;
    }
}

