/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.mixin.MinecraftServerSessionAccessor;
import org.apache.commons.io.file.SimplePathVisitor;
import org.jetbrains.annotations.NotNull;

public class Utilities {
    private static final ConfigHelper config = ConfigHelper.INSTANCE;
    private static final TextileLogger log = new TextileLogger("Textile Backup");

    public static boolean wasSentByPlayer(class_2168 source) {
        return source.method_43737();
    }

    public static void notifyPlayers(@NotNull MinecraftServer server, String msg) {
        class_5250 message = log.getPrefixText();
        message.method_10852((class_2561)class_2561.method_43470((String)msg).method_27692(class_124.field_1068));
        server.method_3760().method_43514((class_2561)message, false);
    }

    public static String getLevelName(MinecraftServer server) {
        return ((MinecraftServerSessionAccessor)server).getSession().method_27005();
    }

    public static Path getWorldFolder(MinecraftServer server) {
        return ((MinecraftServerSessionAccessor)server).getSession().method_27424(class_1937.field_25179);
    }

    public static void deleteDirectory(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimplePathVisitor(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void disableWorldSaving(MinecraftServer server) {
        for (class_3218 serverWorld : server.method_3738()) {
            if (serverWorld == null || serverWorld.field_13957) continue;
            serverWorld.field_13957 = true;
        }
    }

    public static void enableWorldSaving(MinecraftServer server) {
        for (class_3218 serverWorld : server.method_3738()) {
            if (serverWorld == null || !serverWorld.field_13957) continue;
            serverWorld.field_13957 = false;
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static Path getBackupRootPath(String worldName) {
        Path path = Path.of(Utilities.config.get().backupDirectoryPath, new String[0]).toAbsolutePath();
        if (Utilities.config.get().perWorldBackup) {
            path = path.resolve(worldName);
        }
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return path;
    }

    public static boolean isBlacklisted(Path path) {
        if (path.getFileName().equals(Path.of("session.lock", new String[0]))) {
            return true;
        }
        if (path.getFileName().equals(Path.of("textile_status.data", new String[0]))) {
            return true;
        }
        return Utilities.config.get().fileBlacklist.stream().anyMatch(path::startsWith);
    }

    public static DateTimeFormatter getDateTimeFormatter() {
        return DateTimeFormatter.ofPattern(Utilities.config.get().dateTimeFormat);
    }

    public static String formatDuration(Duration duration) {
        DateTimeFormatter formatter = duration.toHours() > 0L ? DateTimeFormatter.ofPattern("HH:mm:ss.SSS") : (duration.toMinutes() > 0L ? DateTimeFormatter.ofPattern("mm:ss.SSS") : DateTimeFormatter.ofPattern("ss.SSS"));
        return LocalTime.ofNanoOfDay(duration.toNanos()).format(formatter);
    }
}

