/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create;

import java.time.Instant;
import net.minecraft.server.MinecraftServer;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.core.ActionInitiator;
import net.szum123321.textile_backup.core.create.ExecutableBackup;

public class BackupScheduler {
    private static final ConfigHelper config = ConfigHelper.INSTANCE;
    private static boolean scheduled = false;
    private static long nextBackup = -1L;

    public static void tick(MinecraftServer server) {
        if (BackupScheduler.config.get().backupInterval < 1L) {
            return;
        }
        long now = Instant.now().getEpochSecond();
        if (BackupScheduler.config.get().doBackupsOnEmptyServer || server.method_3760().method_14574() > 0) {
            if (scheduled) {
                if (nextBackup <= now) {
                    Globals.INSTANCE.getQueueExecutor().submit(ExecutableBackup.Builder.newBackupContextBuilder().setServer(server).setInitiator(ActionInitiator.Timer).saveServer().announce().build());
                    nextBackup = now + BackupScheduler.config.get().backupInterval;
                }
            } else {
                nextBackup = now + BackupScheduler.config.get().backupInterval;
                scheduled = true;
            }
        } else if (!BackupScheduler.config.get().doBackupsOnEmptyServer && server.method_3760().method_14574() == 0 && scheduled && nextBackup <= now) {
            Globals.INSTANCE.getQueueExecutor().submit(ExecutableBackup.Builder.newBackupContextBuilder().setServer(server).setInitiator(ActionInitiator.Timer).saveServer().announce().build());
            scheduled = false;
        }
    }
}

