/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.core.ActionInitiator;
import net.szum123321.textile_backup.core.Cleanup;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.WorldSavingState;
import net.szum123321.textile_backup.core.create.compressors.ParallelZipCompressor;
import net.szum123321.textile_backup.core.create.compressors.ZipCompressor;
import net.szum123321.textile_backup.core.create.compressors.tar.AbstractTarArchiver;
import net.szum123321.textile_backup.core.create.compressors.tar.ParallelBZip2Compressor;
import net.szum123321.textile_backup.core.create.compressors.tar.ParallelGzipCompressor;
import org.jetbrains.annotations.NotNull;

public record ExecutableBackup(@NotNull MinecraftServer server, class_2168 commandSource, ActionInitiator initiator, boolean save, boolean cleanup, String comment, LocalDateTime startDate) implements Callable<Void>
{
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final ConfigHelper config = ConfigHelper.INSTANCE;

    public boolean startedByPlayer() {
        return this.initiator == ActionInitiator.Player;
    }

    public void announce() {
        if (ExecutableBackup.config.get().broadcastBackupStart) {
            Utilities.notifyPlayers(this.server, "Warning! Server backup will begin shortly. You may experience some lag.");
        } else {
            log.sendInfoAL(this, "Warning! Server backup will begin shortly. You may experience some lag.", new Object[0]);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Backup started ");
        builder.append(this.initiator.getPrefix());
        if (this.startedByPlayer()) {
            builder.append(this.commandSource.method_9223().getString());
        } else {
            builder.append(this.initiator.getName());
        }
        builder.append(" on: ");
        builder.append(Utilities.getDateTimeFormatter().format(LocalDateTime.now()));
        log.info(builder.toString(), new Object[0]);
    }

    @Override
    public Void call() throws Exception {
        Path outFile = Utilities.getBackupRootPath(Utilities.getLevelName(this.server)).resolve(this.getFileName());
        log.trace("Outfile is: {}", outFile);
        AtomicReference state = new AtomicReference(Optional.empty());
        try {
            this.server.method_19537(() -> {
                if (this.save) {
                    log.sendInfoAL(this.commandSource, "Saving server...", new Object[0]);
                    this.server.method_39218(true, true, false);
                }
                state.set(Optional.of(WorldSavingState.disable(this.server)));
            });
            Globals.INSTANCE.updateTMPFSFlag(this.server);
            log.sendInfoAL(this, "Starting backup", new Object[0]);
            Path world = Utilities.getWorldFolder(this.server);
            log.trace("Minecraft world is: {}", world);
            Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
            Files.createFile(outFile, new FileAttribute[0]);
            int coreCount = ExecutableBackup.config.get().compressionCoreCountLimit <= 0 ? Runtime.getRuntime().availableProcessors() : Math.min(ExecutableBackup.config.get().compressionCoreCountLimit, Runtime.getRuntime().availableProcessors());
            log.trace("Running compression on {} threads. Available cores: {}", coreCount, Runtime.getRuntime().availableProcessors());
            switch (ExecutableBackup.config.get().format) {
                case ZIP: {
                    if (coreCount > 1 && !Globals.INSTANCE.disableTMPFS()) {
                        log.trace("Using PARALLEL Zip Compressor. Threads: {}", coreCount);
                        ParallelZipCompressor.getInstance().createArchive(world, outFile, this, coreCount);
                        break;
                    }
                    log.trace("Using REGULAR Zip Compressor.", new Object[0]);
                    ZipCompressor.getInstance().createArchive(world, outFile, this, coreCount);
                    break;
                }
                case BZIP2: {
                    ParallelBZip2Compressor.getInstance().createArchive(world, outFile, this, coreCount);
                    break;
                }
                case GZIP: {
                    ParallelGzipCompressor.getInstance().createArchive(world, outFile, this, coreCount);
                    break;
                }
                case TAR: {
                    new AbstractTarArchiver().createArchive(world, outFile, this, coreCount);
                }
            }
            if (this.cleanup) {
                new Cleanup(this.commandSource, Utilities.getLevelName(this.server)).call();
            }
            if (ExecutableBackup.config.get().broadcastBackupDone) {
                Utilities.notifyPlayers(this.server, "Done!");
            } else {
                log.sendInfoAL(this, "Done!", new Object[0]);
            }
        }
        catch (Throwable e) {
            log.error("An exception occurred when trying to create a new backup file!", new Object[]{e});
            if (ConfigHelper.INSTANCE.get().integrityVerificationMode.isStrict()) {
                try {
                    Files.delete(outFile);
                }
                catch (IOException ex) {
                    log.error("An exception occurred while trying go delete: {}", outFile, ex);
                }
            }
            if (this.initiator == ActionInitiator.Player) {
                log.sendError(this, "An exception occurred when trying to create new backup file!", new Object[0]);
            }
            throw e;
        }
        finally {
            if (state.get().isPresent()) {
                ((WorldSavingState)state.get().get()).enable(this.server);
            }
        }
        return null;
    }

    private String getFileName() {
        return Utilities.getDateTimeFormatter().format(this.startDate) + (String)(this.comment != null ? "#" + this.comment.replaceAll("[\\\\/:*?\"<>|#]", "") : "") + ExecutableBackup.config.get().format.getCompleteString();
    }

    public static class Builder {
        private MinecraftServer server = null;
        private class_2168 commandSource = null;
        private ActionInitiator initiator = null;
        private boolean save = false;
        private boolean cleanup = true;
        private String comment = null;
        private boolean announce = false;
        private boolean guessInitiator = false;

        public static Builder newBackupContextBuilder() {
            return new Builder();
        }

        public Builder setCommandSource(class_2168 commandSource) {
            this.commandSource = commandSource;
            return this;
        }

        public Builder setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public Builder setInitiator(ActionInitiator initiator) {
            this.initiator = initiator;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder guessInitiator() {
            this.guessInitiator = true;
            return this;
        }

        public Builder saveServer() {
            this.save = true;
            return this;
        }

        public Builder noCleanup() {
            this.cleanup = false;
            return this;
        }

        public Builder announce() {
            this.announce = true;
            return this;
        }

        public ExecutableBackup build() {
            if (this.guessInitiator) {
                this.initiator = Utilities.wasSentByPlayer(this.commandSource) ? ActionInitiator.Player : ActionInitiator.ServerConsole;
            } else if (this.initiator == null) {
                throw new NoSuchElementException("No initiator provided!");
            }
            if (this.server == null) {
                if (this.commandSource != null) {
                    this.setServer(this.commandSource.method_9211());
                } else {
                    throw new RuntimeException("Neither MinecraftServer or ServerCommandSource were provided!");
                }
            }
            ExecutableBackup v = new ExecutableBackup(this.server, this.commandSource, this.initiator, this.save, this.cleanup, this.comment, LocalDateTime.now());
            if (this.announce) {
                v.announce();
            }
            return v;
        }
    }
}

