/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create.compressors.tar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.LinkOption;
import net.szum123321.textile_backup.core.create.ExecutableBackup;
import net.szum123321.textile_backup.core.create.InputSupplier;
import net.szum123321.textile_backup.core.create.compressors.AbstractCompressor;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class AbstractTarArchiver
extends AbstractCompressor {
    protected OutputStream getCompressorOutputStream(OutputStream stream, ExecutableBackup ctx, int coreLimit) throws IOException {
        return stream;
    }

    @Override
    protected OutputStream createArchiveOutputStream(OutputStream stream, ExecutableBackup ctx, int coreLimit) throws IOException {
        TarArchiveOutputStream tar = new TarArchiveOutputStream(this.getCompressorOutputStream(stream, ctx, coreLimit));
        tar.setLongFileMode(3);
        tar.setBigNumberMode(2);
        return tar;
    }

    @Override
    protected void addEntry(InputSupplier input, OutputStream arc) throws IOException {
        try (InputStream fileInputStream = input.getInputStream();){
            TarArchiveEntry entry;
            if (input.getPath().isEmpty()) {
                entry = new TarArchiveEntry(input.getName());
                entry.setSize(input.size());
            } else {
                entry = (TarArchiveEntry)((TarArchiveOutputStream)arc).createArchiveEntry(input.getPath().get(), input.getName(), new LinkOption[0]);
            }
            ((TarArchiveOutputStream)arc).putArchiveEntry((ArchiveEntry)entry);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)arc);
            ((TarArchiveOutputStream)arc).closeArchiveEntry();
        }
    }
}

