/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create.compressors.tar;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.szum123321.textile_backup.core.create.ExecutableBackup;
import net.szum123321.textile_backup.core.create.compressors.tar.AbstractTarArchiver;
import org.anarres.parallelgzip.ParallelGZIPOutputStream;

public class ParallelGzipCompressor
extends AbstractTarArchiver {
    private ExecutorService executorService;

    public static ParallelGzipCompressor getInstance() {
        return new ParallelGzipCompressor();
    }

    @Override
    protected OutputStream getCompressorOutputStream(OutputStream stream, ExecutableBackup ctx, int coreLimit) throws IOException {
        this.executorService = Executors.newFixedThreadPool(coreLimit);
        return new ParallelGZIPOutputStream(stream, this.executorService);
    }

    @Override
    protected void close() {
        this.executorService.shutdown();
    }
}

