/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.digest;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import net.szum123321.textile_backup.core.digest.Hash;

public class BalticHash
implements Hash {
    protected static final long[] IV = new long[]{1653137622115903356L, -5440164096422524820L, 8062258805288266697L, 1511402585362633601L};
    private final long[] state = Arrays.copyOf(IV, IV.length);
    protected final int buffer_limit = this.state.length * 8;
    protected final byte[] _byte_buffer = new byte[(this.state.length + 1) * 8];
    protected final ByteBuffer buffer = ByteBuffer.wrap(this._byte_buffer).order(ByteOrder.LITTLE_ENDIAN);
    protected long hashed_data_length = 0L;

    @Override
    public void update(int b) {
        this.buffer.put((byte)b);
        ++this.hashed_data_length;
        if (this.buffer.position() >= this.buffer_limit) {
            this.round();
        }
    }

    @Override
    public void update(long b) {
        this.buffer.putLong(b);
        this.hashed_data_length += 8L;
        if (this.buffer.position() >= this.buffer_limit) {
            this.round();
        }
    }

    @Override
    public void update(byte[] data, int off, int len) {
        int n;
        for (int pos = 0; pos < len; pos += n) {
            n = Math.min(len - pos, this.buffer_limit - this.buffer.position());
            System.arraycopy(data, off + pos, this._byte_buffer, this.buffer.position(), n);
            this.buffer.position(this.buffer.position() + n);
            if (this.buffer.position() < this.buffer_limit) continue;
            this.round();
        }
        this.hashed_data_length += (long)len;
    }

    @Override
    public long getValue() {
        if (this.buffer.position() != 0) {
            while (this.buffer.position() < this.buffer_limit) {
                this.buffer.put((byte)0);
            }
            this.round();
        }
        long result = this.state[0];
        result ^= this.state[1];
        result ^= this.state[2];
        result ^= this.state[3];
        return this.xorshift64star(result ^= this.hashed_data_length);
    }

    protected void round() {
        int p = this.buffer.position();
        this.buffer.rewind();
        int i = 0;
        while (i < 4) {
            int n = i++;
            this.state[n] = this.state[n] ^ this.buffer.getLong();
        }
        for (i = 0; i < 4; ++i) {
            this.state[i] = this.xorshift64star(this.state[i]);
        }
        if (p > this.buffer_limit) {
            System.arraycopy(this._byte_buffer, this.buffer_limit, this._byte_buffer, 0, this.buffer.limit() - p);
            this.buffer.position(this.buffer.limit() - p);
        } else {
            this.buffer.rewind();
        }
    }

    long xorshift64star(long s) {
        s ^= s >> 12;
        s ^= s << 25;
        s ^= s >> 27;
        return s * 2685821657736338717L;
    }
}

