/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.digest;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.core.DataLeftException;
import net.szum123321.textile_backup.core.create.BrokenFileHandler;
import net.szum123321.textile_backup.core.digest.FileTreeHashBuilder;
import net.szum123321.textile_backup.core.digest.Hash;
import org.jetbrains.annotations.NotNull;

public class HashingInputStream
extends FilterInputStream {
    private final Path path;
    private final Hash hash = Globals.CHECKSUM_SUPPLIER.get();
    private final FileTreeHashBuilder hashBuilder;
    private final BrokenFileHandler brokenFileHandler;
    private long bytesWritten = 0L;

    public HashingInputStream(InputStream in, Path path, FileTreeHashBuilder hashBuilder, BrokenFileHandler brokenFileHandler) {
        super(in);
        this.path = path;
        this.hashBuilder = hashBuilder;
        this.brokenFileHandler = brokenFileHandler;
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        int i;
        try {
            i = this.in.read(b, off, len);
        }
        catch (IOException e) {
            throw new IOException("An exception occurred while trying to access: [" + this.path.toString() + "]", e);
        }
        if (i != -1) {
            this.hash.update(b, off, i);
            this.bytesWritten += (long)i;
        }
        return i;
    }

    @Override
    public int read() throws IOException {
        int i;
        try {
            i = this.in.read();
        }
        catch (IOException e) {
            throw new IOException("An exception occurred while trying to access: [" + this.path.toString() + "]", e);
        }
        if (i != -1) {
            this.hash.update(i);
            ++this.bytesWritten;
        }
        return i;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.hash.update(this.path.getFileName().toString().getBytes(StandardCharsets.UTF_8));
        this.hashBuilder.update(this.path, this.hash.getValue(), this.bytesWritten);
        if (this.in.available() != 0) {
            this.brokenFileHandler.handle(this.path, new DataLeftException(this.in.available()));
        }
        super.close();
    }
}

